/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class BulkTransferAllMessage {
    private final int slotNumber;

    public BulkTransferAllMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static BulkTransferAllMessage decode(class_2540 buf) {
        byte slotNumber = buf.readByte();
        return new BulkTransferAllMessage(slotNumber);
    }

    public static void encode(BulkTransferAllMessage message, class_2540 buf) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(class_3222 player, BulkTransferAllMessage message) {
        block7: {
            class_1703 menu = player.field_7512;
            if (menu == null || message.slotNumber < 0 || message.slotNumber >= menu.field_7761.size()) break block7;
            class_1735 clickedSlot = (class_1735)menu.field_7761.get(message.slotNumber);
            boolean isProbablyMovingToPlayerInventory = false;
            if (!(clickedSlot.field_7871 instanceof class_1661)) {
                isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(menu);
            }
            if (isProbablyMovingToPlayerInventory) {
                ArrayDeque<class_1735> emptySlots = new ArrayDeque<class_1735>();
                ArrayList<class_1735> nonEmptySlots = new ArrayList<class_1735>();
                for (class_1735 slot : menu.field_7761) {
                    if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.field_7871 instanceof class_1661)) continue;
                    if (slot.method_7681()) {
                        nonEmptySlots.add(slot);
                        continue;
                    }
                    if (class_1661.method_7380((int)slot.method_34266())) continue;
                    emptySlots.add(slot);
                }
                for (class_1735 slot : menu.field_7761) {
                    if (!slot.method_7674((class_1657)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                    BulkTransferAllMessage.bulkTransferPreferInventory((class_1657)player, menu, emptySlots, nonEmptySlots, slot);
                }
            } else {
                for (class_1735 slot : menu.field_7761) {
                    if (!slot.method_7674((class_1657)player) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                    menu.method_7593(slot.field_7874, 0, class_1713.field_7794, (class_1657)player);
                }
            }
        }
    }

    private static boolean bulkTransferPreferInventory(class_1657 player, class_1703 menu, Deque<class_1735> emptySlots, List<class_1735> nonEmptySlots, class_1735 slot) {
        class_1661 playerInventory = player.method_31548();
        class_1799 targetStack = slot.method_7677().method_7972();
        if (targetStack.method_7960()) {
            return false;
        }
        menu.method_7593(slot.field_7874, 0, class_1713.field_7790, player);
        for (class_1735 nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            class_1799 stack = slot.method_7677();
            if (!class_1799.method_7984((class_1799)targetStack, (class_1799)stack)) continue;
            boolean bl = hasSpaceLeft = stack.method_7947() < Math.min(slot.method_7675(), slot.method_7676(stack));
            if (!hasSpaceLeft) continue;
            menu.method_7593(nonEmptySlot.field_7874, 0, class_1713.field_7790, player);
            class_1799 mouseItem = menu.method_34255();
            if (!mouseItem.method_7960()) continue;
            return true;
        }
        Iterator<class_1735> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            class_1799 mouseItem;
            class_1735 emptySlot = iterator.next();
            menu.method_7593(emptySlot.field_7874, 0, class_1713.field_7790, player);
            if (emptySlot.method_7681()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = menu.method_34255()).method_7960()) continue;
            return true;
        }
        class_1799 mouseItem = menu.method_34255();
        if (!mouseItem.method_7960()) {
            menu.method_7593(slot.field_7874, 0, class_1713.field_7790, player);
        }
        return false;
    }
}

