/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.core.FluidHandlerBlock;

public class FluidStorageBlockWrapper
implements IIngredientComponentStorage<FluidStack, Integer> {
    private final ServerWorld world;
    private final BlockPos pos;
    private final Direction side;
    private final boolean blockUpdate;
    private final IIngredientComponentStorage<FluidStack, Integer> targetStorage;

    public FluidStorageBlockWrapper(ServerWorld world, BlockPos pos, Direction side, boolean blockUpdate) {
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.blockUpdate = blockUpdate;
        FluidHandlerBlock fluidHandler = new FluidHandlerBlock(world.func_180495_p(pos), (World)world, pos);
        this.targetStorage = this.getComponent().getStorageWrapperHandler(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).wrapComponentStorage((Object)fluidHandler);
    }

    protected void sendBlockUpdate() {
        this.world.func_190524_a(this.pos, Blocks.field_150350_a, this.pos);
    }

    protected void postInsert(FluidStack moved) {
        if (moved != null && GeneralConfig.worldInteractionEvents) {
            SoundEvent soundevent = moved.getFluid().getAttributes().getEmptySound(moved);
            this.world.func_184133_a(null, this.pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (this.blockUpdate) {
            this.sendBlockUpdate();
        }
    }

    protected void postExtract(FluidStack moved) {
        if (moved != null && GeneralConfig.worldInteractionEvents) {
            SoundEvent soundevent = moved.getFluid().getAttributes().getFillSound(moved);
            this.world.func_184133_a(null, this.pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public IngredientComponent<FluidStack, Integer> getComponent() {
        return IngredientComponent.FLUIDSTACK;
    }

    public Iterator<FluidStack> iterator() {
        return this.targetStorage.iterator();
    }

    public Iterator<FluidStack> iterator(@Nonnull FluidStack prototype, Integer matchCondition) {
        return this.targetStorage.iterator((Object)prototype, (Object)matchCondition);
    }

    public long getMaxQuantity() {
        return 1000L;
    }

    public FluidStack insert(@Nonnull FluidStack stack, boolean simulate) {
        if (this.world.func_230315_m_().func_236040_e_() && stack.getFluid().getAttributes().doesVaporize((IBlockDisplayReader)this.world, this.pos, stack)) {
            return FluidStack.EMPTY;
        }
        FluidStack remaining = (FluidStack)this.targetStorage.insert((Object)stack, simulate);
        if (!simulate && stack.getAmount() != remaining.getAmount()) {
            this.postInsert(stack);
        }
        return remaining;
    }

    public FluidStack extract(@Nonnull FluidStack prototype, Integer matchCondition, boolean simulate) {
        FluidStack extracted = (FluidStack)this.targetStorage.extract((Object)prototype, (Object)matchCondition, simulate);
        if (!simulate) {
            this.postExtract(extracted);
        }
        return extracted;
    }

    public FluidStack extract(long maxQuantity, boolean simulate) {
        FluidStack extracted = (FluidStack)this.targetStorage.extract(maxQuantity, simulate);
        if (!simulate) {
            this.postExtract(extracted);
        }
        return extracted;
    }
}

