/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tepis.integratednbt.Additions;
import me.tepis.integratednbt.Capabilities;
import me.tepis.integratednbt.Integration;
import me.tepis.integratednbt.NBTExtractorContainer;
import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTExtractorRemote;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.Wrapper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;

public class NBTExtractorTileEntity
extends TileEntity
implements ICapabilityProvider,
INetworkEventListener<NetworkElement>,
ITickableTileEntity,
INamedContainerProvider,
IInventory {
    public static final int SRC_NBT_SLOT = 0;
    public static final int VAR_OUT_SLOT = 1;
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private CableCapability cableCapability = new CableCapability();
    private NetworkCarrierDefault networkCarrierCapability = new NetworkCarrierDefault();
    private PathElementTile<NBTExtractorTileEntity> pathElementCapability = new PathElementTile((TileEntity)this, (ICable)this.cableCapability);
    private VariableContainerDefault variableContainerCapability = new VariableContainerDefault();
    private NetworkElementProviderSingleton networkElementProviderCapability = new NetworkElementProviderSingleton(){

        public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
            return new NetworkElement();
        }
    };
    private NonNullList<ItemStack> itemStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private InventoryVariableEvaluator<IValue> evaluator = new InventoryVariableEvaluator((IInventory)this, 0, (IValueType)ValueTypes.CATEGORY_ANY);
    private HashSet<NBTPath> expandedPaths;
    private Wrapper<Integer> scrollTop = new Wrapper<Integer>(0);
    private boolean shouldRefreshVariable = false;
    private boolean shouldUpdateOutVariable = false;
    private NBTPath extractionPath = new NBTPath();
    private byte defaultNBTId = 1;
    private NBTExtractorOutputMode outputMode = NBTExtractorOutputMode.REFERENCE;
    private INBT lastEvaluatedNBT = null;
    private Wrapper<INBT> frozenNBT = null;
    private boolean autoRefresh = true;
    private ItemStack frozenNBTItemStack = ItemStack.field_190927_a;

    public NBTExtractorTileEntity() {
        super((TileEntityType)Additions.NBT_EXTRACTOR_TILE_ENTITY.get());
        this.expandedPaths = new HashSet();
        this.expandedPaths.add(new NBTPath());
    }

    public NBTExtractorOutputMode getOutputMode() {
        return this.outputMode;
    }

    public void setOutputMode(NBTExtractorOutputMode outputMode) {
        this.outputMode = outputMode;
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.refreshVariables(true);
            this.shouldUpdateOutVariable = true;
            if (!this.autoRefresh && !ItemStack.func_77989_b((ItemStack)this.func_70301_a(0), (ItemStack)this.frozenNBTItemStack)) {
                this.frozenNBTItemStack = this.func_70301_a(0);
                this.frozenNBT = null;
            }
        }
    }

    public void refreshVariables(boolean sendVariablesUpdateEvent) {
        this.evaluator.refreshVariable(this.networkCarrierCapability.getNetwork(), sendVariablesUpdateEvent);
        this.variableContainerCapability.refreshVariables(this.networkCarrierCapability.getNetwork(), (IInventory)this, sendVariablesUpdateEvent);
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.itemStacks.get(index);
    }

    public void setDefaultNBTId(byte defaultNBTId) {
        this.defaultNBTId = defaultNBTId < 1 || defaultNBTId > 12 ? (byte)1 : defaultNBTId;
        this.func_70296_d();
    }

    public NBTPath getExtractionPath() {
        return this.extractionPath;
    }

    public void setExtractionPath(NBTPath extractionPath) {
        this.extractionPath = extractionPath;
        this.func_70296_d();
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void updateAutoRefresh(boolean autoRefresh) {
        if (this.autoRefresh == autoRefresh) {
            return;
        }
        this.autoRefresh = autoRefresh;
        if (!autoRefresh) {
            this.frozenNBT = null;
            this.frozenNBTItemStack = ItemStack.field_190927_a;
        }
        this.func_70296_d();
    }

    public void updateLastEvaluatedNBT(INBT lastEvaluatedNBT) {
        this.lastEvaluatedNBT = lastEvaluatedNBT;
        if (!this.autoRefresh && this.frozenNBT == null) {
            this.frozenNBT = Wrapper.of(this.lastEvaluatedNBT);
            this.frozenNBTItemStack = this.func_70301_a(0).func_77946_l();
        }
    }

    public HashSet<NBTPath> getExpandedPaths() {
        return this.expandedPaths;
    }

    public Wrapper<Integer> getScrollTop() {
        return this.scrollTop;
    }

    public IVariable<?> getSrcNBTVariable() {
        IPartNetwork partNetwork = (IPartNetwork)NetworkHelpers.getPartNetwork((INetwork)this.networkCarrierCapability.getNetwork()).orElse(null);
        if (partNetwork == null) {
            return null;
        }
        return this.evaluator.getVariable(partNetwork);
    }

    public ITextComponent getFirstErrorMessage() {
        List errors = this.evaluator.getErrors();
        if (errors.isEmpty()) {
            return null;
        }
        return (ITextComponent)errors.get(0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == Capabilities.CABLE_CAPABILITY) {
            return LazyOptional.of(() -> this.cableCapability);
        }
        if (capability == Capabilities.NETWORK_CARRIER_CAPABILITY) {
            return LazyOptional.of(() -> this.networkCarrierCapability);
        }
        if (capability == Capabilities.PATH_ELEMENT_CAPABILITY) {
            return LazyOptional.of(() -> this.pathElementCapability);
        }
        if (capability == Capabilities.VARIABLE_CONTAINER_CAPABILITY) {
            return LazyOptional.of(() -> this.variableContainerCapability);
        }
        if (capability == Capabilities.NETWORK_ELEMENT_PROVIDER) {
            return LazyOptional.of(() -> this.networkElementProviderCapability);
        }
        return super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.itemStacks.size();
    }

    public boolean func_191420_l() {
        return false;
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.itemStacks, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.itemStacks, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.itemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        if (player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0) {
            return true;
        }
        return this.isRemote(player.func_184614_ca()) || this.isRemote(player.func_184592_cb());
    }

    private boolean isRemote(ItemStack itemStack) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (itemStack.func_77973_b() != Additions.NBT_EXTRACTOR_REMOTE.get()) {
            return false;
        }
        CompoundNBT tag = ((NBTExtractorRemote)Additions.NBT_EXTRACTOR_REMOTE.get()).getModNBT(itemStack);
        return tag.func_74764_b("world") && tag.func_74779_i("world").equals(this.field_145850_b.func_234923_W_().func_240901_a_().toString()) && tag.func_74762_e("x") == this.field_174879_c.func_177958_n() && tag.func_74762_e("y") == this.field_174879_c.func_177956_o() && tag.func_74762_e("z") == this.field_174879_c.func_177952_p();
    }

    public void func_174889_b(@Nonnull PlayerEntity player) {
    }

    public void func_174886_c(@Nonnull PlayerEntity player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return Integration.isVariable(stack);
    }

    public Wrapper<INBT> getFrozenValue() {
        if (this.autoRefresh) {
            return null;
        }
        return this.frozenNBT;
    }

    public void func_174888_l() {
        this.itemStacks.clear();
    }

    public boolean hasEventSubscriptions() {
        return true;
    }

    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Collections.singleton(VariableContentsUpdatedEvent.class);
    }

    public void onEvent(INetworkEvent event, NetworkElement networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.refreshVariables(false);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSide()) {
            this.shouldRefreshVariable = true;
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        ListNBT errorsList = new ListNBT();
        NBTClassType.writeNbt(List.class, (String)"errors", (Object)this.evaluator.getErrors(), (CompoundNBT)tag);
        tag.func_218657_a("errors", (INBT)errorsList);
        tag.func_218657_a("path", (INBT)this.extractionPath.toNBT());
        tag.func_74774_a("defaultNBTId", this.defaultNBTId);
        tag.func_74774_a("outputMode", (byte)this.outputMode.ordinal());
        tag.func_74757_a("isAutoRefresh", this.autoRefresh);
        if (!this.autoRefresh) {
            if (this.frozenNBT != null) {
                CompoundNBT compound = new CompoundNBT();
                if (this.frozenNBT.get() != null) {
                    compound.func_218657_a("value", this.frozenNBT.get());
                }
                tag.func_218657_a("frozenNBT", (INBT)compound);
            }
            tag.func_218657_a("frozenNBTItemStack", (INBT)this.frozenNBTItemStack.func_77955_b(new CompoundNBT()));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.itemStacks);
        return tag;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("tile.integratednbt:nbt_extractor.name");
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tag) {
        if (tag.func_74764_b("errors")) {
            this.evaluator.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors", (CompoundNBT)tag));
        }
        if (tag.func_74764_b("path")) {
            this.extractionPath = NBTPath.fromNBT(tag.func_74781_a("path")).orElse(new NBTPath());
        }
        if (tag.func_74764_b("defaultNBTId")) {
            this.defaultNBTId = tag.func_74771_c("defaultNBTId");
        }
        if (tag.func_74764_b("outputMode")) {
            this.outputMode = NBTExtractorOutputMode.values()[tag.func_74771_c("outputMode")];
        }
        if (tag.func_74764_b("isAutoRefresh")) {
            this.autoRefresh = tag.func_74767_n("isAutoRefresh");
            if (!this.autoRefresh) {
                if (tag.func_74764_b("frozenNBT")) {
                    this.frozenNBT = Wrapper.of(tag.func_74775_l("frozenNBT").func_74781_a("value"));
                }
                this.frozenNBTItemStack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("frozenNBTItemStack"));
            }
        }
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.itemStacks);
        this.shouldRefreshVariable = true;
        super.func_230337_a_(blockState, tag);
    }

    public void afterNetworkReAlive() {
        this.shouldRefreshVariable = true;
        this.connected.clear();
    }

    @Nullable
    public Container createMenu(int windowId, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new NBTExtractorContainer(windowId, inventory, this);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.shouldRefreshVariable && this.networkCarrierCapability.getNetwork() != null) {
                this.shouldRefreshVariable = false;
                this.refreshVariables(true);
            }
            if (this.shouldUpdateOutVariable) {
                this.updateOutVariable();
            }
        }
    }

    private void updateOutVariable() {
        ItemStack result;
        if (!((ItemStack)this.itemStacks.get(1)).func_190926_b() && (result = this.outputMode.writeItemStack(() -> {
            this.refreshVariables(true);
            return this.evaluator.getVariableFacade();
        }, (ItemStack)this.itemStacks.get(1), !this.autoRefresh && this.frozenNBT != null ? this.frozenNBT.get() : this.lastEvaluatedNBT, this.extractionPath, this.defaultNBTId, this.func_195044_w())) != null) {
            this.itemStacks.set(1, (Object)result);
        }
    }

    class NetworkElement
    implements IEventListenableNetworkElement<NBTExtractorTileEntity> {
        NetworkElement() {
        }

        public int getUpdateInterval() {
            return 0;
        }

        public boolean isUpdate() {
            return false;
        }

        public void update(INetwork network) {
        }

        public void beforeNetworkKill(INetwork network) {
        }

        public void afterNetworkAlive(INetwork network) {
        }

        public void afterNetworkReAlive(INetwork network) {
            NBTExtractorTileEntity.this.afterNetworkReAlive();
        }

        public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        }

        public boolean onNetworkAddition(INetwork network) {
            if (NBTExtractorTileEntity.this.field_145850_b == null) {
                return false;
            }
            return NetworkHelpers.getPartNetwork((INetwork)network).map(partNetwork -> partNetwork.addVariableContainer(DimPos.of((World)NBTExtractorTileEntity.this.field_145850_b, (BlockPos)NBTExtractorTileEntity.this.field_174879_c))).orElse(false);
        }

        public void onNetworkRemoval(INetwork network) {
            if (NBTExtractorTileEntity.this.field_145850_b == null) {
                return;
            }
            NetworkHelpers.getPartNetwork((INetwork)network).ifPresent(partNetwork -> partNetwork.removeVariableContainer(DimPos.of((World)NBTExtractorTileEntity.this.field_145850_b, (BlockPos)NBTExtractorTileEntity.this.field_174879_c)));
        }

        public void onPreRemoved(INetwork network) {
        }

        public void onPostRemoved(INetwork network) {
        }

        public void onNeighborBlockChange(@Nullable INetwork network, IBlockReader world, Block neighbourBlock, BlockPos neighbourBlockPos) {
        }

        public void setPriorityAndChannel(INetwork network, int priority, int channel) {
        }

        public int getPriority() {
            return 0;
        }

        public int getChannel() {
            return 0;
        }

        public void invalidate(INetwork network) {
            network.invalidateElement((INetworkElement)this);
        }

        public boolean canRevalidate(INetwork network) {
            if (NBTExtractorTileEntity.this.field_145850_b == null) {
                return false;
            }
            return NBTExtractorTileEntity.this.field_145850_b.func_175667_e(NBTExtractorTileEntity.this.func_174877_v());
        }

        public void revalidate(INetwork network) {
            network.revalidateElement((INetworkElement)this);
        }

        public int compareTo(INetworkElement o) {
            return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
        }

        @Nullable
        public Optional<NBTExtractorTileEntity> getNetworkEventListener() {
            return Optional.of(NBTExtractorTileEntity.this);
        }
    }

    class CableCapability
    implements ICable {
        CableCapability() {
        }

        public boolean canConnect(ICable connector, Direction side) {
            return true;
        }

        public boolean isConnected(Direction side) {
            if (NBTExtractorTileEntity.this.connected.isEmpty()) {
                this.updateConnections();
            }
            return (Boolean)NBTExtractorTileEntity.this.connected.get((Object)side);
        }

        public void updateConnections() {
            NBTExtractorTileEntity entity = NBTExtractorTileEntity.this;
            World world = entity.func_145831_w();
            if (world == null) {
                return;
            }
            for (Direction side : Direction.values()) {
                boolean cableConnected = CableHelpers.canCableConnectTo((IBlockReader)world, (BlockPos)entity.func_174877_v(), (Direction)side, (ICable)this);
                entity.connected.put((Enum)side, (Object)cableConnected);
            }
            world.func_175646_b(entity.func_174877_v(), (TileEntity)entity);
            BlockState blockState = world.func_180495_p(NBTExtractorTileEntity.this.field_174879_c);
            world.func_184138_a(NBTExtractorTileEntity.this.field_174879_c, blockState, blockState, 3);
        }

        public void disconnect(Direction side) {
        }

        public void reconnect(Direction side) {
        }

        public ItemStack getItemStack() {
            return new ItemStack((IItemProvider)Additions.NBT_EXTRACTOR_BLOCK_ITEM.get());
        }

        public void destroy() {
        }
    }
}

