/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.InvalidValueTypeException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.block.BlockInvisibleLight;
import org.cyclops.integrateddynamics.block.BlockInvisibleLightConfig;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightConfig;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLightLevels;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanelVariableDriven;

public class PartTypePanelLightDynamic
extends PartTypePanelVariableDriven<PartTypePanelLightDynamic, State> {
    public PartTypePanelLightDynamic(String name) {
        super(name);
    }

    @Override
    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlockStatus();
    }

    @Override
    public State constructDefaultState() {
        return new State();
    }

    @Override
    public int getConsumptionRate(State state) {
        return GeneralConfig.panelLightDynamicBaseConsumption;
    }

    @Override
    protected IgnoredBlockStatus.Status getStatus(PartTypePanelVariableDriven.State state) {
        IgnoredBlockStatus.Status status = super.getStatus(state);
        if (status == IgnoredBlockStatus.Status.ACTIVE && state.getDisplayValue() != null && this.getLightLevel((State)state, state.getDisplayValue()) == 0) {
            return IgnoredBlockStatus.Status.INACTIVE;
        }
        return status;
    }

    @Override
    protected void onValueChanged(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, IValue lastValue, IValue newValue) {
        super.onValueChanged(network, partNetwork, target, state, lastValue, newValue);
        int lightLevel = 0;
        if (newValue != null) {
            lightLevel = this.getLightLevel(state, newValue);
        }
        PartTypePanelLightDynamic.setLightLevel(target, lightLevel);
        state.sendUpdate();
    }

    protected int getLightLevel(State state, IValue value) {
        try {
            return ValueTypeLightLevels.REGISTRY.getLightLevel(value);
        }
        catch (InvalidValueTypeException e) {
            state.addGlobalError((IFormattableTextComponent)new TranslationTextComponent("parttype.integrateddynamics.data_driven_panel.error.invalid_type", new Object[]{new TranslationTextComponent(value.getType().getTranslationKey())}));
            return 0;
        }
    }

    @Override
    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onNetworkRemoval(network, partNetwork, target, state);
        PartTypePanelLightDynamic.setLightLevel(target, 0);
    }

    @Override
    public void onPostRemoved(INetwork network, IPartNetwork partNetwork, PartTarget target, State state) {
        super.onPostRemoved(network, partNetwork, target, state);
        PartTypePanelLightDynamic.setLightLevel(target, 0);
    }

    @Override
    public void onBlockNeighborChange(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, IBlockReader world, Block neighbourBlock, BlockPos neighbourPos) {
        super.onBlockNeighborChange(network, partNetwork, target, state, world, neighbourBlock, neighbourPos);
        PartTypePanelLightDynamic.setLightLevel(target, state.getDisplayValue() == null ? 0 : this.getLightLevel(state, state.getDisplayValue()));
    }

    @Override
    public void postUpdate(INetwork network, IPartNetwork partNetwork, PartTarget target, State state, boolean updated) {
        boolean wasEnabled = this.isEnabled(state);
        super.postUpdate(network, partNetwork, target, state, updated);
        boolean isEnabled = this.isEnabled(state);
        if (wasEnabled != isEnabled) {
            PartTypePanelLightDynamic.setLightLevel(target, isEnabled ? this.getLightLevel(state, state.getDisplayValue()) : 0);
        }
    }

    public static void setLightLevel(PartTarget target, int lightLevel) {
        if (BlockInvisibleLightConfig.invisibleLightBlock) {
            BlockPos pos;
            World world = target.getTarget().getPos().getWorld(true);
            if (world.func_175623_d(pos = target.getTarget().getPos().getBlockPos())) {
                if (lightLevel > 0) {
                    world.func_175656_a(pos, (BlockState)RegistryEntries.BLOCK_INVISIBLE_LIGHT.func_176223_P().func_206870_a((Property)BlockInvisibleLight.LIGHT, (Comparable)Integer.valueOf(lightLevel)));
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        } else {
            TileHelpers.getCapability((DimPos)target.getCenter().getPos(), (Direction)target.getCenter().getSide(), DynamicLightConfig.CAPABILITY).ifPresent(dynamicLight -> dynamicLight.setLightLevel(lightLevel));
        }
    }

    public static class State
    extends PartTypePanelVariableDriven.State<PartTypePanelLightDynamic, State> {
    }
}

