/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.PartTypeAdapter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.item.ItemPart;
import org.cyclops.integrateddynamics.core.network.PartNetworkElement;

public abstract class PartTypeBase<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeAdapter<P, S> {
    private Item item;
    private Block block;
    private final String name;
    private final PartRenderPosition partRenderPosition;
    private final Map<Class<? extends INetworkEvent>, IEventAction> networkEventActions;

    public PartTypeBase(String name, PartRenderPosition partRenderPosition) {
        this.name = name;
        this.partRenderPosition = partRenderPosition;
        this.networkEventActions = this.constructNetworkEventActions();
        this.registerBlock();
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation(this.getMod().getModId(), this.name);
    }

    protected ModBase getMod() {
        return IntegratedDynamics._instance;
    }

    protected void registerBlock() {
        BlockConfig blockConfig = new BlockConfig(this.getMod(), "part_" + this.name, eConfig -> {
            this.block = this.createBlock((BlockConfig)eConfig);
            return this.block;
        }, (eConfig, block) -> {
            this.item = this.createItem((BlockConfig)eConfig, (Block)block);
            return this.item;
        }){

            public String getFullTranslationKey() {
                return PartTypeBase.this.getTranslationKey();
            }
        };
        this.getMod().getConfigHandler().addConfigurable((ExtendedConfig)blockConfig);
    }

    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlock();
    }

    protected Item createItem(BlockConfig blockConfig, Block block) {
        return new ItemPart(new Item.Properties().func_200916_a(blockConfig.getMod().getDefaultItemGroup()), this);
    }

    @Override
    public ResourceLocation getBlockModelPath() {
        return new ResourceLocation(this.getMod().getModId(), "part_" + this.name);
    }

    @Override
    protected String createTranslationKey() {
        return "parttype." + this.getMod().getModId() + "." + this.name;
    }

    @Override
    public INetworkElement createNetworkElement(IPartContainer partContainer, DimPos pos, Direction side) {
        return new PartNetworkElement(this, this.getTarget(PartPos.of(pos, side), partContainer.getPartState(side)));
    }

    @Override
    public ActionResultType onPartActivated(S partState, BlockPos pos, World world, PlayerEntity player, Hand hand, ItemStack heldItem, BlockRayTraceResult hit) {
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        PartPos partPos = PartPos.of(world, pos, hit.func_216354_b());
        if (this.getContainerProvider(partPos).isPresent()) {
            if (!world.func_201670_d()) {
                return PartHelpers.openContainerPart((ServerPlayerEntity)player, partPos, this);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState getBlockState(IPartContainer partContainer, Direction side) {
        return (BlockState)this.getBlock().func_176223_P().func_206870_a((Property)IgnoredBlock.FACING, (Comparable)side);
    }

    @Override
    public BlockState getBaseBlockState() {
        return this.getBlock().func_176223_P();
    }

    @Override
    public void loadTooltip(S state, List<ITextComponent> lines) {
        if (!state.isEnabled()) {
            lines.add((ITextComponent)new TranslationTextComponent("parttype.integrateddynamics.tooltip.disabled"));
        }
        lines.add((ITextComponent)new TranslationTextComponent("item.integrateddynamics.general.id", new Object[]{state.getId()}));
    }

    protected Map<Class<? extends INetworkEvent>, IEventAction> constructNetworkEventActions() {
        return new IdentityHashMap<Class<? extends INetworkEvent>, IEventAction>();
    }

    @Override
    public final boolean hasEventSubscriptions() {
        return !this.networkEventActions.isEmpty();
    }

    @Override
    public final Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return this.networkEventActions.keySet();
    }

    @Override
    public final void onEvent(INetworkEvent event, IPartNetworkElement<P, S> networkElement) {
        if (networkElement.getTarget().getCenter().getPos().isLoaded()) {
            this.networkEventActions.get(event.getClass()).onAction(event.getNetwork(), networkElement.getTarget(), networkElement.getPartState(), event);
        }
    }

    @Override
    public boolean forceLightTransparency(S state) {
        return false;
    }

    @Override
    public void writeExtraGuiData(PacketBuffer packetBuffer, PartPos pos, ServerPlayerEntity player) {
        packetBuffer.func_180714_a(this.getUniqueName().toString());
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public Block getBlock() {
        return this.block;
    }

    @Override
    public PartRenderPosition getPartRenderPosition() {
        return this.partRenderPosition;
    }

    public static interface IEventAction<P extends IPartType<P, S>, S extends IPartState<P>, E extends INetworkEvent> {
        public void onAction(INetwork var1, PartTarget var2, S var3, E var4);
    }
}

