/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.AttachCapabilitiesEventPart;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartStateBase<P extends IPartType>
implements IPartState<P>,
IDirtyMarkListener {
    private boolean dirty = false;
    private boolean update = false;
    private boolean forceBlockUpdateRender = false;
    private int updateInterval = this.getDefaultUpdateInterval();
    private int priority = 0;
    private int channel = 0;
    private Direction targetSide = null;
    private int id = -1;
    private Map<IAspect, IAspectProperties> aspectProperties = new IdentityHashMap<IAspect, IAspectProperties>();
    private boolean enabled = true;
    private CapabilityDispatcher capabilities = null;
    private IdentityHashMap<Capability<?>, LazyOptional<Object>> volatileCapabilities = new IdentityHashMap();

    @Override
    public void writeToNBT(CompoundNBT tag) {
        tag.func_74768_a("updateInterval", this.updateInterval);
        tag.func_74768_a("priority", this.priority);
        tag.func_74768_a("channel", this.channel);
        if (this.targetSide != null) {
            tag.func_74768_a("targetSide", this.targetSide.ordinal());
        }
        tag.func_74768_a("id", this.id);
        this.writeAspectProperties("aspectProperties", tag);
        tag.func_74757_a("enabled", this.enabled);
        if (this.capabilities != null) {
            tag.func_218657_a("ForgeCaps", (INBT)this.capabilities.serializeNBT());
        }
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.updateInterval = tag.func_74762_e("updateInterval");
        this.priority = tag.func_74762_e("priority");
        this.channel = tag.func_74762_e("channel");
        if (tag.func_150297_b("targetSide", 3)) {
            this.targetSide = Direction.values()[tag.func_74762_e("targetSide")];
        }
        this.id = tag.func_74762_e("id");
        this.aspectProperties.clear();
        this.readAspectProperties("aspectProperties", tag);
        this.enabled = tag.func_74767_n("enabled");
        if (this.capabilities != null && tag.func_74764_b("ForgeCaps")) {
            this.capabilities.deserializeNBT(tag.func_74775_l("ForgeCaps"));
        }
    }

    protected void writeAspectProperties(String name, CompoundNBT tag) {
        CompoundNBT mapTag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Map.Entry<IAspect, IAspectProperties> entry : this.aspectProperties.entrySet()) {
            CompoundNBT entryTag = new CompoundNBT();
            entryTag.func_74778_a("key", entry.getKey().getUniqueName().toString());
            if (entry.getValue() != null) {
                entryTag.func_218657_a("value", (INBT)entry.getValue().toNBT());
            }
            list.add((Object)entryTag);
        }
        mapTag.func_218657_a("map", (INBT)list);
        tag.func_218657_a(name, (INBT)mapTag);
    }

    public void readAspectProperties(String name, CompoundNBT tag) {
        CompoundNBT mapTag = tag.func_74775_l(name);
        ListNBT list = mapTag.func_150295_c("map", 10);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT entryTag = list.func_150305_b(i);
                IAspect key = Aspects.REGISTRY.getAspect(new ResourceLocation(entryTag.func_74779_i("key")));
                AspectProperties value = null;
                if (entryTag.func_74764_b("value")) {
                    value = new AspectProperties();
                    value.fromNBT(entryTag.func_74775_l("value"));
                }
                if (key == null || value == null) continue;
                this.aspectProperties.put(key, value);
            }
        }
    }

    @Override
    public void generateId() {
        this.id = IntegratedDynamics.globalCounters.getNext("part");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setTargetSideOverride(Direction targetSide) {
        this.targetSide = targetSide;
    }

    @Override
    @Nullable
    public Direction getTargetSideOverride() {
        return this.targetSide;
    }

    @Override
    public boolean isDirtyAndReset() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    @Override
    public boolean isUpdateAndReset() {
        boolean wasUpdate = this.update;
        this.update = false;
        return wasUpdate;
    }

    @Override
    public void forceBlockRenderUpdate() {
        this.forceBlockUpdateRender = true;
    }

    @Override
    public boolean isForceBlockRenderUpdateAndReset() {
        boolean wasForceBlockUpdateRender = this.forceBlockUpdateRender;
        this.forceBlockUpdateRender = false;
        return wasForceBlockUpdateRender;
    }

    public void onDirty() {
        this.dirty = true;
        this.forceBlockRenderUpdate();
    }

    public void sendUpdate() {
        this.update = true;
    }

    @Override
    public IAspectProperties getAspectProperties(IAspect aspect) {
        return this.aspectProperties.get(aspect);
    }

    @Override
    public void setAspectProperties(IAspect aspect, IAspectProperties properties) {
        this.aspectProperties.put(aspect, properties);
        this.sendUpdate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (this.enabled != wasEnabled) {
            this.sendUpdate();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void gatherCapabilities(P partType) {
        AttachCapabilitiesEventPart event = new AttachCapabilitiesEventPart((IPartType)partType, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities(), event.getListeners()) : null;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        LazyOptional<Object> o = this.volatileCapabilities.get(capability);
        if (o != null && o.isPresent()) {
            return o.cast();
        }
        return this.capabilities == null ? LazyOptional.empty() : this.capabilities.getCapability(capability);
    }

    @Override
    public <T> void addVolatileCapability(Capability<T> capability, LazyOptional<T> value) {
        this.volatileCapabilities.put(capability, value);
    }

    @Override
    public void removeVolatileCapability(Capability<?> capability) {
        this.volatileCapabilities.remove(capability);
    }

    protected int getDefaultUpdateInterval() {
        return GeneralConfig.defaultPartUpdateFreq;
    }
}

