/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistry;

public class ContainerAspectSettings
extends InventoryContainer {
    public static final String BUTTON_EXIT = "button_exit";
    public static final int BUTTON_SETTINGS = 1;
    private static final int PAGE_SIZE = 3;
    private final Optional<PartTarget> target;
    private final Optional<IPartContainer> partContainer;
    private final Optional<IPartType> partType;
    private final World world;
    private final IAspect<?, ?> aspect;
    private final BiMap<Integer, IAspectPropertyTypeInstance> propertyIds = HashBiMap.create();

    public ContainerAspectSettings(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, (IInventory)new Inventory(0), Optional.empty(), Optional.empty(), Optional.empty(), ContainerAspectSettings.readAspect(packetBuffer));
    }

    protected static IAspect<?, ?> readAspect(PacketBuffer packetBuffer) {
        String name = packetBuffer.func_218666_n();
        return Objects.requireNonNull(AspectRegistry.getInstance().getAspect(new ResourceLocation(name)), String.format("Could not find an aspect by name %s", name));
    }

    public ContainerAspectSettings(int id, PlayerInventory playerInventory, IInventory inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, Optional<IPartType> partType, IAspect<?, ?> aspect) {
        super(RegistryEntries.CONTAINER_ASPECT_SETTINGS, id, playerInventory, inventory);
        this.target = target;
        this.partType = partType;
        this.partContainer = partContainer;
        this.world = this.player.func_130014_f_();
        this.aspect = aspect;
        this.addPlayerInventory(this.player.field_71071_by, 8, 131);
        for (IAspectPropertyTypeInstance property : aspect.getPropertyTypes()) {
            this.propertyIds.put((Object)this.getNextValueId(), (Object)property);
        }
        this.putButtonAction(BUTTON_EXIT, (s, containerExtended) -> {
            if (!this.world.func_201670_d()) {
                PartHelpers.openContainerPart((ServerPlayerEntity)playerInventory.field_70458_d, this.getTarget().get().getCenter(), this.getPartType().get());
            }
        });
    }

    public BiMap<Integer, IAspectPropertyTypeInstance> getPropertyIds() {
        return this.propertyIds;
    }

    public Optional<IPartType> getPartType() {
        return this.partType;
    }

    public IAspect getAspect() {
        return this.aspect;
    }

    public Optional<PartTarget> getTarget() {
        return this.target;
    }

    protected void initializeValues() {
        super.initializeValues();
        IAspectProperties properties = this.aspect.getProperties(this.getPartType().get(), this.getTarget().get(), this.getPartState().get());
        for (IAspectPropertyTypeInstance property : this.aspect.getPropertyTypes()) {
            this.setValue(property, (IValue)properties.getValue(property));
        }
    }

    public void setValue(IAspectPropertyTypeInstance property, IValue value) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)((Integer)this.propertyIds.inverse().get((Object)property)), (INBT)ValueHelpers.serializeRaw(value));
    }

    public Optional<IPartState> getPartState() {
        return this.partContainer.map(p -> p.getPartState(this.getTarget().get().getCenter().getSide()));
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    protected int getSizeInventory() {
        return 0;
    }

    public <T extends IValueType<V>, V extends IValue> V getPropertyValue(IAspectPropertyTypeInstance<T, V> property) {
        INBT value;
        if (this.propertyIds.containsValue(property) && (value = ValueNotifierHelpers.getValueNbt((IValueNotifier)this, (int)((Integer)this.propertyIds.inverse().get(property)))) != null) {
            return (V)ValueHelpers.deserializeRaw(property.getType(), value);
        }
        return null;
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        IAspectPropertyTypeInstance property;
        super.onUpdate(valueId, value);
        if (!this.world.func_201670_d() && (property = (IAspectPropertyTypeInstance)this.propertyIds.get((Object)valueId)) != null) {
            IPartType partType = this.getPartType().get();
            PartTarget target = this.getTarget().get();
            IPartState partState = this.getPartState().get();
            IAspectProperties aspectProperties = this.aspect.getProperties(partType, target, partState);
            aspectProperties = aspectProperties.clone();
            Object trueValue = ValueHelpers.deserializeRaw(property.getType(), value.func_74781_a(ValueNotifierHelpers.KEY));
            aspectProperties.setValue(property, trueValue);
            this.aspect.setProperties(partType, target, partState, aspectProperties);
            NetworkHelpers.getNetwork(target.getCenter()).ifPresent(network -> network.getEventBus().post(new VariableContentsUpdatedEvent((INetwork)network)));
        }
    }
}

