/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.ingredient;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.core.ingredient.WrappedIngredients;

public class ExtendedIngredientsList<T, M>
extends WrappedIngredients {
    private final IngredientComponent<T, M> component;
    private final List<T> instances;

    public ExtendedIngredientsList(IMixedIngredients base, IngredientComponent<T, M> component, List<T> instances) {
        super(base);
        this.component = component;
        this.instances = instances;
    }

    protected boolean forComponent(IngredientComponent<?, ?> component) {
        return component == this.component;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getComponents() {
        Set components = Sets.newIdentityHashSet();
        components.addAll(super.getComponents());
        components.add(this.component);
        return components;
    }

    public <T2> List<T2> getInstances(IngredientComponent<T2, ?> ingredientComponent) {
        List<T2> superList = super.getInstances(ingredientComponent);
        return this.forComponent(ingredientComponent) ? this.instances : superList;
    }
}

