/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNumber;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.build.OperatorBuilder;
import org.cyclops.integrateddynamics.core.evaluate.operator.IterativeFunction;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;

public class OperatorBuilders {
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> LOGICAL = OperatorBuilder.forType(ValueTypes.BOOLEAN).appendKind("logical");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> LOGICAL_1_PREFIX = LOGICAL.inputTypes(1, (IValueType)ValueTypes.BOOLEAN).renderPattern(IConfigRenderPattern.PREFIX_1);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> LOGICAL_2 = LOGICAL.inputTypes(2, (IValueType)ValueTypes.BOOLEAN).renderPattern(IConfigRenderPattern.INFIX);
    public static final IOperatorValuePropagator<Integer, IValue> PROPAGATOR_INTEGER_VALUE = ValueTypeInteger.ValueInteger::of;
    public static final IOperatorValuePropagator<Long, IValue> PROPAGATOR_LONG_VALUE = ValueTypeLong.ValueLong::of;
    public static final IOperatorValuePropagator<Boolean, IValue> PROPAGATOR_BOOLEAN_VALUE = ValueTypeBoolean.ValueBoolean::of;
    public static final IOperatorValuePropagator<Double, IValue> PROPAGATOR_DOUBLE_VALUE = ValueTypeDouble.ValueDouble::of;
    public static final IOperatorValuePropagator<String, IValue> PROPAGATOR_STRING_VALUE = ValueTypeString.ValueString::of;
    public static final IOperatorValuePropagator<Optional<INBT>, IValue> PROPAGATOR_NBT_VALUE = ValueTypeNbt.ValueNbt::of;
    public static final IOperatorValuePropagator<Optional<CompoundNBT>, IValue> PROPAGATOR_NBT_COMPOUND_VALUE = opt -> ValueTypeNbt.ValueNbt.of(opt.map(t -> t));
    public static final IOperatorValuePropagator<ResourceLocation, ValueTypeString.ValueString> PROPAGATOR_RESOURCELOCATION_MODNAME = resourceLocation -> {
        String modId = resourceLocation.func_110624_b();
        Optional mod = ModList.get().getModContainerById(modId);
        String modName = mod.map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse("Minecraft");
        return ValueTypeString.ValueString.of(modName);
    };
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ARITHMETIC = OperatorBuilder.forType(ValueTypes.CATEGORY_NUMBER).appendKind("arithmetic").conditionalOutputTypeDeriver((operator, input) -> {
        IValueType[] original = ValueHelpers.from(input);
        IValueTypeNumber[] types = new IValueTypeNumber[original.length];
        for (int i = 0; i < original.length; ++i) {
            if (original[i].isCategory()) {
                return original[i];
            }
            types[i] = (IValueTypeNumber)original[i];
        }
        return ValueTypes.CATEGORY_NUMBER.getLowestType(types);
    });
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ARITHMETIC_2 = ARITHMETIC.inputTypes(2, (IValueType)ValueTypes.CATEGORY_NUMBER).renderPattern(IConfigRenderPattern.INFIX);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ARITHMETIC_2_PREFIX = ARITHMETIC.inputTypes(2, (IValueType)ValueTypes.CATEGORY_NUMBER).renderPattern(IConfigRenderPattern.PREFIX_2);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INTEGER = OperatorBuilder.forType(ValueTypes.INTEGER).appendKind("integer");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INTEGER_1_SUFFIX = INTEGER.inputTypes(1, (IValueType)ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.SUFFIX_1);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INTEGER_2 = INTEGER.inputTypes(2, (IValueType)ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.INFIX);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> RELATIONAL = OperatorBuilder.forType(ValueTypes.BOOLEAN).appendKind("relational");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> RELATIONAL_2 = RELATIONAL.inputTypes(2, (IValueType)ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.INFIX);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> BINARY = OperatorBuilder.forType(ValueTypes.INTEGER).appendKind("binary");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> BINARY_1_PREFIX = BINARY.inputTypes(1, (IValueType)ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.PREFIX_1);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> BINARY_2 = BINARY.inputTypes(2, (IValueType)ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.INFIX);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> STRING = OperatorBuilder.forType(ValueTypes.STRING).appendKind("string");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> STRING_1_PREFIX = STRING.inputTypes(1, (IValueType)ValueTypes.STRING).renderPattern(IConfigRenderPattern.PREFIX_1);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> STRING_2 = STRING.inputTypes(2, (IValueType)ValueTypes.STRING).renderPattern(IConfigRenderPattern.INFIX);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> STRING_2_LONG = STRING.inputTypes(2, (IValueType)ValueTypes.STRING).renderPattern(IConfigRenderPattern.INFIX_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> DOUBLE = OperatorBuilder.forType(ValueTypes.DOUBLE).appendKind("double");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> DOUBLE_1_PREFIX = DOUBLE.inputTypes(1, (IValueType)ValueTypes.DOUBLE).renderPattern(IConfigRenderPattern.PREFIX_1);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NUMBER = OperatorBuilder.forType(ValueTypes.CATEGORY_NUMBER).appendKind("number");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NUMBER_1_PREFIX = DOUBLE.inputTypes(1, (IValueType)ValueTypes.CATEGORY_NUMBER).renderPattern(IConfigRenderPattern.PREFIX_1);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NULLABLE = OperatorBuilder.forType(ValueTypes.CATEGORY_NULLABLE).appendKind("general");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NULLABLE_1_PREFIX = NULLABLE.inputTypes(1, (IValueType)ValueTypes.CATEGORY_NULLABLE).renderPattern(IConfigRenderPattern.PREFIX_1);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> LIST = OperatorBuilder.forType(ValueTypes.LIST).appendKind("list");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> LIST_1_PREFIX = LIST.inputTypes(1, (IValueType)ValueTypes.LIST).renderPattern(IConfigRenderPattern.PREFIX_1);
    public static final OperatorBuilder BLOCK = OperatorBuilder.forType(ValueTypes.OBJECT_BLOCK).appendKind("block");
    public static final OperatorBuilder BLOCK_1_SUFFIX_LONG = BLOCK.inputTypes(1, (IValueType)ValueTypes.OBJECT_BLOCK).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG);
    public static final OperatorBuilder BLOCK_INFIX_VERYLONG = BLOCK.inputTypes(2, (IValueType)ValueTypes.OBJECT_BLOCK).renderPattern(IConfigRenderPattern.INFIX_VERYLONG);
    public static final IOperatorValuePropagator<OperatorBase.SafeVariablesGetter, Optional<SoundType>> BLOCK_SOUND = input -> {
        ValueObjectTypeBlock.ValueBlock block = input.getValue(0, ValueTypes.OBJECT_BLOCK);
        if (block.getRawValue().isPresent()) {
            return Optional.of(((BlockState)block.getRawValue().get()).func_177230_c().func_220072_p((BlockState)block.getRawValue().get()));
        }
        return Optional.empty();
    };
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ITEMSTACK = OperatorBuilder.forType(ValueTypes.OBJECT_ITEMSTACK).appendKind("itemstack");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ITEMSTACK_1_PREFIX_LONG = ITEMSTACK.inputTypes(1, (IValueType)ValueTypes.OBJECT_ITEMSTACK).renderPattern(IConfigRenderPattern.PREFIX_1_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ITEMSTACK_1_SUFFIX_LONG = ITEMSTACK.inputTypes(1, (IValueType)ValueTypes.OBJECT_ITEMSTACK).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ITEMSTACK_2 = ITEMSTACK.inputTypes(2, (IValueType)ValueTypes.OBJECT_ITEMSTACK).renderPattern(IConfigRenderPattern.INFIX);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ITEMSTACK_2_LONG = ITEMSTACK.inputTypes(2, (IValueType)ValueTypes.OBJECT_ITEMSTACK).renderPattern(IConfigRenderPattern.INFIX_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ITEMSTACK_1_INTEGER_1 = ITEMSTACK.inputTypes(ValueTypes.OBJECT_ITEMSTACK, ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.INFIX);
    public static final IterativeFunction.PrePostBuilder<ItemStack, IValue> FUNCTION_ITEMSTACK = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueObjectTypeItemStack.ValueItemStack value = input.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        return value.getRawValue();
    });
    public static final IterativeFunction.PrePostBuilder<ItemStack, Integer> FUNCTION_ITEMSTACK_TO_INT = FUNCTION_ITEMSTACK.appendPost(PROPAGATOR_INTEGER_VALUE);
    public static final IterativeFunction.PrePostBuilder<ItemStack, Boolean> FUNCTION_ITEMSTACK_TO_BOOLEAN = FUNCTION_ITEMSTACK.appendPost(PROPAGATOR_BOOLEAN_VALUE);
    public static final IterativeFunction.PrePostBuilder<IEnergyStorage, IValue> FUNCTION_ENERGYSTORAGEITEM = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueObjectTypeItemStack.ValueItemStack a = input.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
        if (!a.getRawValue().func_190926_b()) {
            return (IEnergyStorage)a.getRawValue().getCapability(CapabilityEnergy.ENERGY).orElse(null);
        }
        return null;
    });
    public static final IterativeFunction.PrePostBuilder<IEnergyStorage, Integer> FUNCTION_CONTAINERITEM_TO_INT = FUNCTION_ENERGYSTORAGEITEM.appendPost(PROPAGATOR_INTEGER_VALUE);
    public static final IterativeFunction.PrePostBuilder<IEnergyStorage, Boolean> FUNCTION_CONTAINERITEM_TO_BOOLEAN = FUNCTION_ENERGYSTORAGEITEM.appendPost(PROPAGATOR_BOOLEAN_VALUE);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ENTITY = OperatorBuilder.forType(ValueTypes.OBJECT_ENTITY).appendKind("entity");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ENTITY_1_SUFFIX = ENTITY.inputTypes(1, (IValueType)ValueTypes.OBJECT_ENTITY).renderPattern(IConfigRenderPattern.SUFFIX_1);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> ENTITY_1_SUFFIX_LONG = ENTITY.inputTypes(1, (IValueType)ValueTypes.OBJECT_ENTITY).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG);
    public static final IterativeFunction.PrePostBuilder<Entity, IValue> FUNCTION_ENTITY = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueObjectTypeEntity.ValueEntity a = input.getValue(0, ValueTypes.OBJECT_ENTITY);
        return a.getRawValue().isPresent() ? a.getRawValue().get() : null;
    });
    public static final IterativeFunction.PrePostBuilder<Entity, Double> FUNCTION_ENTITY_TO_DOUBLE = FUNCTION_ENTITY.appendPost(PROPAGATOR_DOUBLE_VALUE);
    public static final IterativeFunction.PrePostBuilder<Entity, Boolean> FUNCTION_ENTITY_TO_BOOLEAN = FUNCTION_ENTITY.appendPost(PROPAGATOR_BOOLEAN_VALUE);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> FLUIDSTACK = OperatorBuilder.forType(ValueTypes.OBJECT_FLUIDSTACK).appendKind("fluidstack");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> FLUIDSTACK_1_SUFFIX_LONG = FLUIDSTACK.inputTypes(1, (IValueType)ValueTypes.OBJECT_FLUIDSTACK).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> FLUIDSTACK_2 = FLUIDSTACK.inputTypes(2, (IValueType)ValueTypes.OBJECT_FLUIDSTACK).renderPattern(IConfigRenderPattern.INFIX);
    public static final IterativeFunction.PrePostBuilder<FluidStack, IValue> FUNCTION_FLUIDSTACK = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueObjectTypeFluidStack.ValueFluidStack a = input.getValue(0, ValueTypes.OBJECT_FLUIDSTACK);
        return a.getRawValue();
    });
    public static final IterativeFunction.PrePostBuilder<FluidStack, Integer> FUNCTION_FLUIDSTACK_TO_INT = FUNCTION_FLUIDSTACK.appendPost(PROPAGATOR_INTEGER_VALUE);
    public static final IterativeFunction.PrePostBuilder<FluidStack, Boolean> FUNCTION_FLUIDSTACK_TO_BOOLEAN = FUNCTION_FLUIDSTACK.appendPost(PROPAGATOR_BOOLEAN_VALUE);
    public static final IterativeFunction.PrePostBuilder<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue> FUNCTION_OPERATOR_TAKE_OPERATOR = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        IOperator innerOperator = input.getValue(0, ValueTypes.OPERATOR).getRawValue();
        if (innerOperator.getRequiredInputLength() == 1) {
            IValue applyingValue = input.getValue(1);
            IFormattableTextComponent error = innerOperator.validateTypes(new IValueType[]{applyingValue.getType()});
            if (error != null) {
                throw new EvaluationException(error);
            }
        } else if (!ValueHelpers.correspondsTo(input.getVariables()[1].getType(), innerOperator.getInputTypes()[0])) {
            TranslationTextComponent error = new TranslationTextComponent("operator.integrateddynamics.error.wrong_currying_type", new Object[]{new TranslationTextComponent(innerOperator.getTranslationKey()), new TranslationTextComponent(input.getVariables()[0].getType().getTranslationKey()), 0, new TranslationTextComponent(innerOperator.getInputTypes()[0].getTranslationKey())});
            throw new EvaluationException((IFormattableTextComponent)error);
        }
        return Pair.of((Object)innerOperator, (Object)new OperatorBase.SafeVariablesGetter.Shifted(1, input.getVariables()));
    });
    public static final IterativeFunction.PrePostBuilder<IOperator, IValue> FUNCTION_ONE_OPERATOR = IterativeFunction.PrePostBuilder.begin().appendPre(input -> OperatorBuilders.getSafeOperator(input.getValue(0, ValueTypes.OPERATOR), ValueTypes.CATEGORY_ANY));
    public static final IterativeFunction.PrePostBuilder<IOperator, IValue> FUNCTION_ONE_PREDICATE = IterativeFunction.PrePostBuilder.begin().appendPre(input -> OperatorBuilders.getSafePredictate(input.getValue(0, ValueTypes.OPERATOR)));
    public static final IterativeFunction.PrePostBuilder<Pair<IOperator, IOperator>, IValue> FUNCTION_TWO_OPERATORS = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        IOperator second = OperatorBuilders.getSafeOperator(input.getValue(1, ValueTypes.OPERATOR), ValueTypes.CATEGORY_ANY);
        IValueType[] secondInputs = second.getInputTypes();
        if (secondInputs.length < 1) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.operator_param_wrong_input_length", new Object[]{1, second.getLocalizedNameFull(), secondInputs.length}));
        }
        IValueType secondInputType = secondInputs[0];
        if (ValueHelpers.correspondsTo(secondInputType, ValueTypes.OPERATOR)) {
            secondInputType = ValueTypes.CATEGORY_ANY;
        }
        IOperator first = OperatorBuilders.getSafeOperator(input.getValue(0, ValueTypes.OPERATOR), secondInputType);
        return Pair.of((Object)first, (Object)second);
    });
    public static final IterativeFunction.PrePostBuilder<Pair<IOperator, IOperator>, IValue> FUNCTION_TWO_PREDICATES = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        IOperator first = OperatorBuilders.getSafePredictate(input.getValue(0, ValueTypes.OPERATOR));
        IOperator second = OperatorBuilders.getSafePredictate(input.getValue(1, ValueTypes.OPERATOR));
        return Pair.of((Object)first, (Object)second);
    });
    public static final IterativeFunction.PrePostBuilder<Triple<IOperator, IOperator, IOperator>, IValue> FUNCTION_THREE_OPERATORS = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        IOperator third = OperatorBuilders.getSafeOperator(input.getValue(2, ValueTypes.OPERATOR), ValueTypes.CATEGORY_ANY);
        IValueType[] types = third.getInputTypes();
        if (types.length < 2) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.operator_param_wrong_input_length", new Object[]{2, third.getLocalizedNameFull(), types.length}));
        }
        IValueType firstOutputType = types[0];
        IValueType secondOutputType = types[1];
        if (ValueHelpers.correspondsTo(firstOutputType, ValueTypes.OPERATOR)) {
            firstOutputType = ValueTypes.CATEGORY_ANY;
        }
        if (ValueHelpers.correspondsTo(secondOutputType, ValueTypes.OPERATOR)) {
            secondOutputType = ValueTypes.CATEGORY_ANY;
        }
        IOperator first = OperatorBuilders.getSafeOperator(input.getValue(0, ValueTypes.OPERATOR), firstOutputType);
        IOperator second = OperatorBuilders.getSafeOperator(input.getValue(1, ValueTypes.OPERATOR), secondOutputType);
        return Triple.of((Object)first, (Object)second, (Object)third);
    });
    public static final IterativeFunction.PrePostBuilder<Pair<IOperator, OperatorBase.SafeVariablesGetter>, IValue> FUNCTION_OPERATOR_TAKE_OPERATOR_LIST = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueTypeOperator.ValueOperator valueOperator = input.getValue(0, ValueTypes.OPERATOR);
        IOperator innerOperator = valueOperator.getRawValue();
        input.getValue(1, ValueTypes.LIST);
        return Pair.of((Object)innerOperator, (Object)new OperatorBase.SafeVariablesGetter.Shifted(1, input.getVariables()));
    });
    public static OperatorBuilder.IConditionalOutputTypeDeriver OPERATOR_CONDITIONAL_OUTPUT_DERIVER = (operator, variablesAll) -> {
        try {
            Object value = variablesAll[0].getValue();
            if (!(value instanceof ValueTypeOperator.ValueOperator)) {
                return ValueTypes.CATEGORY_ANY;
            }
            IOperator innerOperator = ((ValueTypeOperator.ValueOperator)value).getRawValue();
            Object[] variables = (IVariable[])ArrayUtils.subarray((Object[])variablesAll, (int)1, (int)variablesAll.length);
            int requiredLength = innerOperator.getRequiredInputLength();
            if (requiredLength == variables.length) {
                IFormattableTextComponent error = innerOperator.validateTypes(ValueHelpers.from((IVariable[])variables));
                if (error != null) {
                    return innerOperator.getOutputType();
                }
                return innerOperator.getConditionalOutputType((IVariable[])variables);
            }
            if (variables.length > requiredLength) {
                IVariable[] acceptableVariables = (IVariable[])ArrayUtils.subarray((Object[])variables, (int)0, (int)requiredLength);
                IVariable[] remainingVariables = (IVariable[])ArrayUtils.subarray((Object[])variables, (int)requiredLength, (int)variables.length);
                IValue result = ValueHelpers.evaluateOperator(innerOperator, acceptableVariables);
                if (result.getType() != ValueTypes.OPERATOR) {
                    throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("operator.integrateddynamics.error.currying_overflow", new Object[]{new TranslationTextComponent(innerOperator.getTranslationKey()), requiredLength, variables.length, new TranslationTextComponent(result.getType().getTranslationKey())}));
                }
                IOperator nextOperator = ((ValueTypeOperator.ValueOperator)result).getRawValue();
                IFormattableTextComponent error = nextOperator.validateTypes(ValueHelpers.from(remainingVariables));
                if (error != null) {
                    return nextOperator.getOutputType();
                }
                return nextOperator.getConditionalOutputType(remainingVariables);
            }
            return ValueTypes.OPERATOR;
        }
        catch (EvaluationException e) {
            return ValueTypes.CATEGORY_ANY;
        }
    };
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> OPERATOR = OperatorBuilder.forType(ValueTypes.OPERATOR).appendKind("operator");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> OPERATOR_2_INFIX_LONG = OPERATOR.inputTypes(ValueTypes.OPERATOR, ValueTypes.CATEGORY_ANY).renderPattern(IConfigRenderPattern.INFIX);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> OPERATOR_1_PREFIX_LONG = OPERATOR.inputTypes(ValueTypes.OPERATOR).renderPattern(IConfigRenderPattern.PREFIX_1_LONG);
    public static final IterativeFunction.PrePostBuilder<ResourceLocation, IValue> FUNCTION_STRING_TO_RESOURCE_LOCATION = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueTypeString.ValueString a = input.getValue(0, ValueTypes.STRING);
        return ValueHelpers.createResourceLocationInEvaluation(a.getRawValue());
    });
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NBT = OperatorBuilder.forType(ValueTypes.NBT).appendKind("nbt");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NBT_1_PREFIX_LONG = NBT.inputTypes(ValueTypes.NBT).renderPattern(IConfigRenderPattern.PREFIX_1_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NBT_1_SUFFIX_LONG = NBT.inputTypes(ValueTypes.NBT).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NBT_2 = NBT.inputTypes(ValueTypes.NBT, ValueTypes.STRING).renderPattern(IConfigRenderPattern.INFIX_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NBT_2_NBT = NBT.inputTypes(ValueTypes.NBT, ValueTypes.NBT).renderPattern(IConfigRenderPattern.INFIX_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> NBT_3 = NBT.inputTypes(ValueTypes.NBT, ValueTypes.STRING, ValueTypes.STRING).output(ValueTypes.NBT).renderPattern(IConfigRenderPattern.INFIX_2_LONG);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, IValue> FUNCTION_NBT = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueTypeNbt.ValueNbt value = input.getValue(0, ValueTypes.NBT);
        return value.getRawValue();
    });
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, IValue> FUNCTION_NBT_COMPOUND_ENTRY = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueTypeNbt.ValueNbt valueNbt = input.getValue(0, ValueTypes.NBT);
        ValueTypeString.ValueString valueString = input.getValue(1, ValueTypes.STRING);
        return valueNbt.getRawValue().filter(tag -> tag instanceof CompoundNBT).map(tag -> ((CompoundNBT)tag).func_74781_a(valueString.getRawValue()));
    });
    public static final IterativeFunction.PrePostBuilder<Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter>, IValue> FUNCTION_NBT_COPY_FOR_VALUE = IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
        ValueTypeNbt.ValueNbt valueNbt = input.getValue(0, ValueTypes.NBT);
        ValueTypeString.ValueString valueString = input.getValue(1, ValueTypes.STRING);
        return Triple.of(valueNbt.getRawValue().filter(t -> t instanceof CompoundNBT).map(t -> (CompoundNBT)t).map(CompoundNBT::func_74737_b), (Object)valueString.getRawValue(), (Object)new OperatorBase.SafeVariablesGetter.Shifted(2, input.getVariables()));
    });
    public static final IOperatorValuePropagator<Optional<INBT>, Optional<CompoundNBT>> PROPAGATOR_NBT_COMPOUND = opt -> opt.filter(t -> t instanceof CompoundNBT).map(t -> (CompoundNBT)t);
    public static final IterativeFunction.PrePostBuilder<Optional<CompoundNBT>, IValue> FUNCTION_NBT_COMPOUND = FUNCTION_NBT.appendPre(PROPAGATOR_NBT_COMPOUND);
    public static final IterativeFunction.PrePostBuilder<Optional<CompoundNBT>, Integer> FUNCTION_NBT_COMPOUND_TO_INT = FUNCTION_NBT_COMPOUND.appendPost(PROPAGATOR_INTEGER_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<CompoundNBT>, Boolean> FUNCTION_NBT_COMPOUND_TO_BOOLEAN = FUNCTION_NBT_COMPOUND.appendPost(PROPAGATOR_BOOLEAN_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Integer> FUNCTION_NBT_COMPOUND_ENTRY_TO_INT = FUNCTION_NBT_COMPOUND_ENTRY.appendPost(PROPAGATOR_INTEGER_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Long> FUNCTION_NBT_COMPOUND_ENTRY_TO_LONG = FUNCTION_NBT_COMPOUND_ENTRY.appendPost(PROPAGATOR_LONG_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Double> FUNCTION_NBT_COMPOUND_ENTRY_TO_DOUBLE = FUNCTION_NBT_COMPOUND_ENTRY.appendPost(PROPAGATOR_DOUBLE_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Boolean> FUNCTION_NBT_COMPOUND_ENTRY_TO_BOOLEAN = FUNCTION_NBT_COMPOUND_ENTRY.appendPost(PROPAGATOR_BOOLEAN_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, String> FUNCTION_NBT_COMPOUND_ENTRY_TO_STRING = FUNCTION_NBT_COMPOUND_ENTRY.appendPost(PROPAGATOR_STRING_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Optional<INBT>> FUNCTION_NBT_COMPOUND_ENTRY_TO_NBT = FUNCTION_NBT_COMPOUND_ENTRY.appendPost(PROPAGATOR_NBT_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Integer> FUNCTION_NBT_TO_INT = FUNCTION_NBT.appendPost(PROPAGATOR_INTEGER_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Long> FUNCTION_NBT_TO_LONG = FUNCTION_NBT.appendPost(PROPAGATOR_LONG_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Double> FUNCTION_NBT_TO_DOUBLE = FUNCTION_NBT.appendPost(PROPAGATOR_DOUBLE_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Boolean> FUNCTION_NBT_TO_BOOLEAN = FUNCTION_NBT.appendPost(PROPAGATOR_BOOLEAN_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, String> FUNCTION_NBT_TO_STRING = FUNCTION_NBT.appendPost(PROPAGATOR_STRING_VALUE);
    public static final IterativeFunction.PrePostBuilder<Optional<INBT>, Optional<INBT>> FUNCTION_NBT_TO_NBT = FUNCTION_NBT.appendPost(PROPAGATOR_NBT_VALUE);
    public static final IterativeFunction.PrePostBuilder<Triple<Optional<CompoundNBT>, String, OperatorBase.SafeVariablesGetter>, Optional<CompoundNBT>> FUNCTION_NBT_COPY_FOR_VALUE_TO_NBT = FUNCTION_NBT_COPY_FOR_VALUE.appendPost(PROPAGATOR_NBT_COMPOUND_VALUE);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INGREDIENTS = OperatorBuilder.forType(ValueTypes.OBJECT_INGREDIENTS).appendKind("ingredients");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INGREDIENTS_1_PREFIX_LONG = INGREDIENTS.inputTypes(ValueTypes.OBJECT_INGREDIENTS).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INGREDIENTS_3_ITEMSTACK = INGREDIENTS.inputTypes(ValueTypes.OBJECT_INGREDIENTS, ValueTypes.INTEGER, ValueTypes.OBJECT_ITEMSTACK).renderPattern(IConfigRenderPattern.INFIX_2_LONG).output(ValueTypes.OBJECT_INGREDIENTS);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INGREDIENTS_3_FLUIDSTACK = INGREDIENTS.inputTypes(ValueTypes.OBJECT_INGREDIENTS, ValueTypes.INTEGER, ValueTypes.OBJECT_FLUIDSTACK).renderPattern(IConfigRenderPattern.INFIX_2_LONG).output(ValueTypes.OBJECT_INGREDIENTS);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INGREDIENTS_3_INTEGER = INGREDIENTS.inputTypes(ValueTypes.OBJECT_INGREDIENTS, ValueTypes.INTEGER, ValueTypes.INTEGER).renderPattern(IConfigRenderPattern.INFIX_2_LONG).output(ValueTypes.OBJECT_INGREDIENTS);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> INGREDIENTS_2_LIST = INGREDIENTS.inputTypes(ValueTypes.OBJECT_INGREDIENTS, ValueTypes.LIST).renderPattern(IConfigRenderPattern.INFIX_LONG).output(ValueTypes.OBJECT_INGREDIENTS);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> RECIPE = OperatorBuilder.forType(ValueTypes.OBJECT_RECIPE).appendKind("recipe");
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> RECIPE_1_SUFFIX_LONG = RECIPE.inputTypes(ValueTypes.OBJECT_RECIPE).renderPattern(IConfigRenderPattern.SUFFIX_1_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> RECIPE_2_INFIX = RECIPE.inputTypes(ValueTypes.OBJECT_RECIPE, ValueTypes.OBJECT_INGREDIENTS).renderPattern(IConfigRenderPattern.INFIX_LONG);
    public static final OperatorBuilder<OperatorBase.SafeVariablesGetter> RECIPE_2_PREFIX = RECIPE.inputTypes(ValueTypes.OBJECT_INGREDIENTS, ValueTypes.OBJECT_INGREDIENTS).renderPattern(IConfigRenderPattern.PREFIX_2_LONG);

    public static IOperator getSafeOperator(ValueTypeOperator.ValueOperator value, IValueType expectedOutput) throws EvaluationException {
        IOperator operator = value.getRawValue();
        if (!ValueHelpers.correspondsTo(operator.getOutputType(), expectedOutput)) {
            TranslationTextComponent error = new TranslationTextComponent("operator.integrateddynamics.error.illegal_property", new Object[]{new TranslationTextComponent(expectedOutput.getTranslationKey()), new TranslationTextComponent(operator.getOutputType().getTranslationKey()), operator.getLocalizedNameFull()});
            throw new EvaluationException((IFormattableTextComponent)error);
        }
        return operator;
    }

    public static IOperator getSafePredictate(ValueTypeOperator.ValueOperator value) throws EvaluationException {
        return OperatorBuilders.getSafeOperator(value, ValueTypes.BOOLEAN);
    }

    public static OperatorBuilder.ITypeValidator createOperatorTypeValidator(IValueType<?> ... expectedSubTypes) {
        int subOperatorLength = expectedSubTypes.length;
        TranslationTextComponent expected = new TranslationTextComponent(Helpers.createPatternOfLength(subOperatorLength), (Object[])ValueHelpers.from(expectedSubTypes));
        return (arg_0, arg_1) -> OperatorBuilders.lambda$createOperatorTypeValidator$19(subOperatorLength, (ITextComponent)expected, arg_0, arg_1);
    }

    public static OperatorBase.IFunction createFunctionIngredientsList(Callable<IngredientComponent<?, ?>> componentReference) {
        return variables -> {
            IngredientComponent component = null;
            try {
                component = (IngredientComponent)componentReference.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
            ValueObjectTypeIngredients.ValueIngredients value = variables.getValue(0, ValueTypes.OBJECT_INGREDIENTS);
            List list = Lists.newArrayList();
            if (value.getRawValue().isPresent()) {
                list = ((IMixedIngredients)value.getRawValue().get()).getInstances(component);
            }
            return ValueTypeList.ValueList.ofList(componentHandler.getValueType(), list.stream().map(i -> componentHandler.toValue(i)).collect(Collectors.toList()));
        };
    }

    public static <VT extends IValueType<V>, V extends IValue, T, M> List<T> unwrapIngredientComponentList(IngredientComponent<T, M> component, ValueTypeList.ValueList<VT, V> list) throws EvaluationException {
        IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
        if (list.getRawValue().getValueType() != componentHandler.getValueType()) {
            throw new EvaluationException((IFormattableTextComponent)new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_list_value_type", new Object[]{list.getRawValue().getValueType(), componentHandler.getValueType()}));
        }
        ArrayList listTransformed = Lists.newArrayListWithExpectedSize((int)list.getRawValue().getLength());
        for (IValue value : list.getRawValue()) {
            listTransformed.add(componentHandler.toInstance(value));
        }
        return listTransformed;
    }

    public static <T> IterativeFunction.PrePostBuilder<T, IValue> getItemCapability(@Nullable ICapabilityReference<T> capabilityReference) {
        return IterativeFunction.PrePostBuilder.begin().appendPre(input -> {
            ValueObjectTypeItemStack.ValueItemStack a = input.getValue(0, ValueTypes.OBJECT_ITEMSTACK);
            if (!a.getRawValue().func_190926_b()) {
                return a.getRawValue().getCapability(capabilityReference.getReference(), null).orElse(null);
            }
            return null;
        });
    }

    private static /* synthetic */ IFormattableTextComponent lambda$createOperatorTypeValidator$19(int subOperatorLength, ITextComponent expected, OperatorBase operator, IValueType[] input) {
        if (input.length == 0 || !ValueHelpers.correspondsTo(input[0], ValueTypes.OPERATOR)) {
            String givenName = input.length == 0 ? "null" : input[0].getTranslationKey();
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_operator_operator", new Object[]{0, givenName});
        }
        if (input.length != subOperatorLength + 1) {
            IValueType[] operatorInputs = Arrays.copyOfRange(input, 1, input.length);
            TranslationTextComponent given = new TranslationTextComponent(Helpers.createPatternOfLength(operatorInputs.length), (Object[])ValueHelpers.from(operatorInputs));
            return new TranslationTextComponent("valuetype.integrateddynamics.error.invalid_operator_signature", new Object[]{expected, given});
        }
        return null;
    }

    public static interface ICapabilityReference<T> {
        public Capability<T> getReference();
    }
}

