/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;

public abstract class CableModelBase
extends DelegatingDynamicItemAndBlockModel {
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private static final Cache<Triple<IRenderState, Direction, RenderType>, List<BakedQuad>> CACHE_QUADS = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final int RADIUS = 4;
    private static final int TEXTURE_SIZE = 16;
    private static final int LENGTH_CONNECTION = 6;
    private static final int LENGTH_CONNECTION_LIMITED = 1;
    private static final int INV_LENGTH_CONNECTION = 10;
    public static final float MIN = 0.375f;
    public static final float MAX = 0.625f;
    private static final PartRenderPosition CABLE_RENDERPOSITION = new PartRenderPosition(-1.0f, 0.375f, 0.25f, 0.25f);
    private final float[][][] quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f);
    protected static final ItemCameraTransforms TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.03125f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), (Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.03125f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f))));

    public CableModelBase(BlockState blockState, Direction facing, Random rand, IModelData modelData) {
        super(blockState, facing, rand, modelData);
    }

    public CableModelBase(ItemStack itemStack, World world, LivingEntity entity) {
        super(itemStack, world, entity);
    }

    public CableModelBase() {
    }

    protected static float[][][] makeQuadVertexes(float min, float max, float length) {
        return new float[][][]{new float[][]{{min, length, min}, {max, length, min}, {max, max, min}, {min, max, min}}, new float[][]{{min, max, min}, {min, max, max}, {min, length, max}, {min, length, min}}, new float[][]{{min, max, max}, {max, max, max}, {max, length, max}, {min, length, max}}, new float[][]{{max, length, min}, {max, length, max}, {max, max, max}, {max, max, min}}};
    }

    private Direction getSideFromVecs(Vector3d a, Vector3d b, Vector3d c) {
        int dir;
        int n = a.field_72448_b == b.field_72448_b && b.field_72448_b == c.field_72448_b ? 0 : (dir = a.field_72450_a == b.field_72450_a && b.field_72450_a == c.field_72450_a ? 2 : 4);
        if (dir == 0) {
            dir += c.field_72448_b >= 0.5 ? 1 : 0;
        } else if (dir == 2) {
            dir += c.field_72450_a >= 0.5 ? 1 : 0;
        } else if (dir == 4) {
            dir += c.field_72449_c >= 0.5 ? 1 : 0;
        }
        return Direction.func_82600_a((int)dir);
    }

    public List<BakedQuad> getFacadeQuads(BlockState blockState, Direction side, PartRenderPosition partRenderPosition) {
        Random rand = new Random();
        IBakedModel model = RenderHelpers.getBakedModel((BlockState)blockState);
        List originalQuads = model.func_200117_a(blockState, side, rand);
        return originalQuads.stream().flatMap(originalQuad -> {
            LinkedList ret = Lists.newLinkedList();
            if (partRenderPosition == PartRenderPosition.NONE) {
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, 0.0f, 0.0f, 1.0f, 1.0f, side);
            } else {
                float w = partRenderPosition.getWidthFactorSide();
                float h = partRenderPosition.getHeightFactorSide();
                float u0 = 0.0f;
                float v0 = 0.0f;
                float u1 = (1.0f - w) / 2.0f;
                float v1 = (1.0f - h) / 2.0f;
                float u2 = u1 + w;
                float v2 = v1 + h;
                float u3 = 1.0f;
                float v3 = 1.0f;
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u0, v0, u1, v1, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u1, v0, u2, v1, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u2, v0, u3, v1, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u0, v1, u1, v2, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u2, v1, u3, v2, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u0, v2, u1, v3, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u1, v2, u2, v3, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u2, v2, u3, v3, side);
            }
            return ret.stream();
        }).collect(Collectors.toList());
    }

    private void addFacadeQuad(List<BakedQuad> quads, BakedQuad originalQuad, float u0, float v0, float u1, float v1, Direction side) {
        Vector3f from = new Vector3f(u0 * 16.0f, v0 * 16.0f, 0.0f);
        Vector3f to = new Vector3f(u1 * 16.0f, v1 * 16.0f, 0.0f);
        TextureAtlasSprite texture = originalQuad.func_187508_a();
        float[] uvArray = new float[]{16.0f - u1 * 16.0f, 16.0f - v1 * 16.0f, 16.0f - u0 * 16.0f, 16.0f - v0 * 16.0f};
        int ROTATION_NONE = 0;
        BlockFaceUV blockFaceUV = new BlockFaceUV(uvArray, ROTATION_NONE);
        Direction NO_FACE_CULLING = null;
        String DUMMY_TEXTURE_NAME = "";
        BlockPartFace blockPartFace = new BlockPartFace(NO_FACE_CULLING, originalQuad.func_178211_c(), DUMMY_TEXTURE_NAME, blockFaceUV);
        SimpleModelTransform transformation = new SimpleModelTransform(CableModelBase.getMatrix(CableModelBase.getRotation(side)));
        BlockPartRotation DEFAULT_ROTATION = null;
        boolean APPLY_SHADING = true;
        quads.add(FACE_BAKERY.func_228824_a_(from, to, blockPartFace, texture, Direction.NORTH, (IModelTransform)transformation, DEFAULT_ROTATION, APPLY_SHADING, null));
    }

    public static TransformationMatrix getMatrix(ModelRotation modelRotation) {
        return modelRotation.func_225615_b_();
    }

    public static ModelRotation getRotation(Direction facing) {
        switch (facing) {
            case DOWN: {
                return ModelRotation.X90_Y180;
            }
            case UP: {
                return ModelRotation.X270_Y180;
            }
            case NORTH: {
                return ModelRotation.X0_Y0;
            }
            case SOUTH: {
                return ModelRotation.X0_Y180;
            }
            case WEST: {
                return ModelRotation.X0_Y270;
            }
            case EAST: {
                return ModelRotation.X0_Y90;
            }
        }
        throw new IllegalArgumentException(String.valueOf(facing));
    }

    protected abstract boolean isRealCable(IModelData var1);

    protected abstract Optional<BlockState> getFacade(IModelData var1);

    protected abstract boolean isConnected(IModelData var1, Direction var2);

    protected abstract boolean hasPart(IModelData var1, Direction var2);

    protected abstract PartRenderPosition getPartRenderPosition(IModelData var1, Direction var2);

    protected abstract boolean shouldRenderParts(IModelData var1);

    protected abstract IBakedModel getPartModel(IModelData var1, Direction var2);

    protected abstract IRenderState getRenderState(IModelData var1);

    public List<BakedQuad> getGeneralQuads() {
        IRenderState renderState;
        Triple cacheKey = null;
        List cachedQuads = null;
        if (GeneralConfig.cacheCableModels && (renderState = this.getRenderState(this.modelData)) != null) {
            cacheKey = Triple.of((Object)renderState, (Object)this.facing, (Object)MinecraftForgeClient.getRenderLayer());
            cachedQuads = (List)CACHE_QUADS.getIfPresent((Object)cacheKey);
        }
        if (cachedQuads == null) {
            boolean isConnected;
            LinkedList ret = Lists.newLinkedList();
            TextureAtlasSprite texture = this.func_177554_e();
            Optional<BlockState> blockStateHolder = this.getFacade(this.modelData);
            boolean renderCable = this.isItemStack() || this.isRealCable(this.modelData) && (!blockStateHolder.isPresent() && MinecraftForgeClient.getRenderLayer() == RenderType.func_228639_c_() || blockStateHolder.isPresent() && MinecraftForgeClient.getRenderLayer() == RenderType.func_228645_f_());
            for (Direction side : Direction.values()) {
                boolean hasPart;
                isConnected = this.isItemStack() ? side == Direction.EAST || side == Direction.WEST : this.isConnected(this.modelData, side);
                boolean bl = hasPart = !this.isItemStack() && this.hasPart(this.modelData, side);
                if (hasPart && this.shouldRenderParts(this.modelData)) {
                    try {
                        ret.addAll(this.getPartModel(this.modelData, side).getQuads(this.blockState, this.facing, this.rand, this.modelData));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!renderCable) continue;
                if (isConnected || hasPart) {
                    int i = 0;
                    float[][][] quadVertexes = this.quadVertexes;
                    if (hasPart) {
                        PartRenderPosition partRenderPosition = this.getPartRenderPosition(this.modelData, side);
                        float depthFactor = partRenderPosition == PartRenderPosition.NONE ? 0.0f : partRenderPosition.getDepthFactor();
                        quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f - depthFactor);
                    }
                    for (float[][] v : quadVertexes) {
                        Vector3d v1 = CableModelBase.rotate((Vector3d)new Vector3d((double)v[0][0] - 0.5, (double)v[0][1] - 0.5, (double)v[0][2] - 0.5), (Direction)side).func_72441_c(0.5, 0.5, 0.5);
                        Vector3d v2 = CableModelBase.rotate((Vector3d)new Vector3d((double)v[1][0] - 0.5, (double)v[1][1] - 0.5, (double)v[1][2] - 0.5), (Direction)side).func_72441_c(0.5, 0.5, 0.5);
                        Vector3d v3 = CableModelBase.rotate((Vector3d)new Vector3d((double)v[2][0] - 0.5, (double)v[2][1] - 0.5, (double)v[2][2] - 0.5), (Direction)side).func_72441_c(0.5, 0.5, 0.5);
                        Vector3d v4 = CableModelBase.rotate((Vector3d)new Vector3d((double)v[3][0] - 0.5, (double)v[3][1] - 0.5, (double)v[3][2] - 0.5), (Direction)side).func_72441_c(0.5, 0.5, 0.5);
                        Direction realSide = this.getSideFromVecs(v1, v2, v3);
                        boolean invert = i == 2 || i == 1;
                        int length = hasPart ? 1 : 6;
                        int[] data = Ints.concat((int[][])new int[][]{CableModelBase.vertexToInts((float)((float)v1.field_72450_a), (float)((float)v1.field_72448_b), (float)((float)v1.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v2.field_72450_a), (float)((float)v2.field_72448_b), (float)((float)v2.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v3.field_72450_a), (float)((float)v3.field_72448_b), (float)((float)v3.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? 0.0f : (float)length)), CableModelBase.vertexToInts((float)((float)v4.field_72450_a), (float)((float)v4.field_72448_b), (float)((float)v4.field_72449_c), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? 0.0f : (float)length))});
                        ++i;
                        ForgeHooksClient.fillNormal((int[])data, (Direction)realSide);
                        ret.add(new BakedQuad(data, -1, realSide, texture, true));
                    }
                    continue;
                }
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)0.625f, (TextureAtlasSprite)texture, (Direction)side);
            }
            if (blockStateHolder.isPresent() && this.shouldRenderParts(this.modelData) && MinecraftForgeClient.getRenderLayer() != null && RenderTypeLookup.canRenderInLayer((BlockState)blockStateHolder.get(), (RenderType)MinecraftForgeClient.getRenderLayer())) {
                for (Direction side : Direction.values()) {
                    boolean hasPart;
                    isConnected = this.isItemStack() ? side == Direction.EAST || side == Direction.WEST : this.isConnected(this.modelData, side);
                    PartRenderPosition partRenderPosition = PartRenderPosition.NONE;
                    boolean bl = hasPart = !this.isItemStack() && this.hasPart(this.modelData, side);
                    if (hasPart) {
                        partRenderPosition = this.getPartRenderPosition(this.modelData, side);
                    } else if (isConnected) {
                        partRenderPosition = CABLE_RENDERPOSITION;
                    }
                    ret.addAll(this.getFacadeQuads(blockStateHolder.get(), side, partRenderPosition));
                }
            }
            if (this.isItemStack()) {
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (Direction)Direction.EAST);
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (Direction)Direction.WEST);
            }
            cachedQuads = ret;
            if (cacheKey != null) {
                CACHE_QUADS.put((Object)cacheKey, (Object)cachedQuads);
            }
        }
        return cachedQuads;
    }

    public TextureAtlasSprite func_177554_e() {
        return RegistryEntries.BLOCK_CABLE.texture;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        return TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)pos, TileMultipartTicking.class).map(TileMultipartTicking::getConnectionState).orElse((IModelData)EmptyModelData.INSTANCE);
    }

    public boolean func_230044_c_() {
        return false;
    }

    public ItemCameraTransforms func_177552_f() {
        return TRANSFORMS;
    }
}

