/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.network;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.PartPos;

public interface IPositionedAddonsNetworkIngredients<T, M>
extends IPositionedAddonsNetwork,
IIngredientComponentStorageObservable<T, M> {
    @Override
    public IngredientComponent<T, M> getComponent();

    public long getRateLimit();

    public IIngredientComponentStorage<T, M> getPositionedStorage(PartPos var1);

    public void setPositionedStorageFilter(PartPos var1, @Nullable PositionedAddonsNetworkIngredientsFilter<T> var2);

    @Nullable
    public PositionedAddonsNetworkIngredientsFilter<T> getPositionedStorageFilter(PartPos var1);

    default public Iterator<T> getRawInstances(PartPos pos) {
        Iterator it = this.getPositionedStorage(pos).iterator();
        PositionedAddonsNetworkIngredientsFilter<T> filter = this.getPositionedStorageFilter(pos);
        if (filter != null) {
            it = Iterators.filter((Iterator)it, filter::testView);
        }
        return it;
    }

    @Nullable
    default public IIngredientComponentStorage<T, M> getPositionedStorageUnsafe(PartPos pos) {
        DimPos dimPos = pos.getPos();
        World world = dimPos.getWorld(true);
        Optional tile = TileHelpers.getSafeTile((IBlockReader)world, (BlockPos)dimPos.getBlockPos(), TileEntity.class);
        return tile.map(tileEntity -> this.getComponent().getStorage((ICapabilityProvider)tileEntity, pos.getSide())).orElse(null);
    }

    public IIngredientComponentStorage<T, M> getChannel(int var1);

    @Nullable
    default public <S> S getChannelExternal(Capability<S> capability, int channel) {
        IIngredientComponentStorageWrapperHandler wrapperHandler = this.getComponent().getStorageWrapperHandler(capability);
        return (S)(wrapperHandler != null ? wrapperHandler.wrapStorage(this.getChannel(channel)) : null);
    }

    public Map<PartPos, Long> getLastSecondDurationIndex();

    public void resetLastSecondDurationsIndex();
}

