/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.network;

import java.util.Collection;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCraftingHandler;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;

public interface INetworkCraftingHandlerRegistry
extends IRegistry {
    public <C extends INetworkCraftingHandler> C register(C var1);

    public Collection<INetworkCraftingHandler> getCraftingHandlers();

    default public <T, M> boolean isCrafting(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition) {
        for (INetworkCraftingHandler craftingHandler : this.getCraftingHandlers()) {
            if (!craftingHandler.isCrafting(network, ingredientsNetwork, channel, ingredientComponent, instance, matchCondition)) continue;
            return true;
        }
        return false;
    }

    default public <T, M> boolean canCraft(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel) {
        for (INetworkCraftingHandler craftingHandler : this.getCraftingHandlers()) {
            if (!craftingHandler.canCraft(network, ingredientsNetwork, channel)) continue;
            return true;
        }
        return false;
    }

    default public <T, M> boolean craft(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel, IngredientComponent<T, M> ingredientComponent, T instance, M matchCondition, boolean ignoreExistingJobs) {
        for (INetworkCraftingHandler craftingHandler : this.getCraftingHandlers()) {
            if (!craftingHandler.craft(network, ingredientsNetwork, channel, ingredientComponent, instance, matchCondition, ignoreExistingJobs)) continue;
            return true;
        }
        return false;
    }
}

