/*
 * Decompiled with CFR 0.152.
 */
package draylar.inmis;

import draylar.inmis.api.TrinketCompat;
import draylar.inmis.config.BackpackInfo;
import draylar.inmis.config.InmisConfig;
import draylar.inmis.item.BackpackItem;
import draylar.inmis.item.DyeableBackpackItem;
import draylar.inmis.item.EnderBackpackItem;
import draylar.inmis.mixin.trinkets.TrinketsMixinPlugin;
import draylar.inmis.network.ServerNetworking;
import draylar.inmis.ui.BackpackScreenHandler;
import draylar.omegaconfig.OmegaConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1304;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Inmis
implements ModInitializer {
    public static final boolean TRINKETS_LOADED = FabricLoader.getInstance().isModLoaded("trinkets");
    public static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 CONTAINER_ID = Inmis.id("backpack");
    public static final class_5321<class_1761> GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)CONTAINER_ID);
    public static final InmisConfig CONFIG = (InmisConfig)OmegaConfig.register(InmisConfig.class);
    public static final class_3917<BackpackScreenHandler> CONTAINER_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)CONTAINER_ID, (Object)new ExtendedScreenHandlerType(BackpackScreenHandler::new));
    public static final List<BackpackItem> BACKPACKS = new ArrayList<BackpackItem>();
    public static final class_1792 ENDER_POUCH = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Inmis.id("ender_pouch"), (Object)((Object)new EnderBackpackItem()));

    public void onInitialize() {
        this.registerBackpacks();
        ServerNetworking.init();
        this.setupTrinkets();
    }

    private void registerBackpacks() {
        class_2378.method_39197((class_2378)class_7923.field_44687, GROUP, (Object)FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)class_7923.field_41178.method_10223(Inmis.id("frayed_backpack")))).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.inmis.backpack")).method_47324());
        InmisConfig defaultConfig = new InmisConfig();
        for (BackpackInfo backpack : Inmis.CONFIG.backpacks) {
            FabricItemSettings settings = new FabricItemSettings().maxCount(1);
            if (Inmis.CONFIG.allowBackpacksInChestplate) {
                settings.equipmentSlot(stack -> class_1304.field_6174);
            }
            if (backpack.isFireImmune()) {
                settings.fireproof();
            }
            if (backpack.getOpenSound() == null) {
                Optional<BackpackInfo> any = defaultConfig.backpacks.stream().filter(info -> info.getName().equals(backpack.getName())).findAny();
                any.ifPresent(backpackInfo -> backpack.setOpenSound(backpackInfo.getOpenSound()));
                if (backpack.getOpenSound() == null) {
                    LOGGER.info(String.format("Could not find a sound event for %s in inmis.json config.", backpack.getName()));
                    LOGGER.info("Consider regenerating your config, or assigning the openSound value. Rolling with defaults for now.");
                    backpack.setOpenSound("minecraft:item.armor.equip_leather");
                }
            }
            BackpackItem item = TRINKETS_LOADED && Inmis.CONFIG.enableTrinketCompatibility ? TrinketCompat.createTrinketBackpack(backpack, settings) : (backpack.isDyeable() ? new DyeableBackpackItem(backpack, (class_1792.class_1793)settings) : new BackpackItem(backpack, (class_1792.class_1793)settings));
            BackpackItem registered = (BackpackItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("inmis", backpack.getName().toLowerCase() + "_backpack"), (Object)((Object)item)));
            BACKPACKS.add(registered);
            ItemGroupEvents.modifyEntriesEvent(GROUP).register(entries -> entries.method_45421((class_1935)registered));
            if (!TRINKETS_LOADED || !Inmis.CONFIG.enableTrinketCompatibility) continue;
            TrinketCompat.registerTrinketBackpack(item);
        }
        ItemGroupEvents.modifyEntriesEvent(GROUP).register(entries -> entries.method_45421((class_1935)ENDER_POUCH));
    }

    private void setupTrinkets() {
        if (TrinketsMixinPlugin.isTrinketsLoaded && Inmis.CONFIG.enableTrinketCompatibility) {
            TrinketCompat.registerTrinketPredicate();
        }
    }

    public static boolean isBackpackEmpty(class_1799 stack) {
        class_2499 tag = stack.method_7948().method_10554("Inventory", 10);
        for (class_2520 element : tag) {
            class_2487 stackTag = (class_2487)element;
            class_1799 backpackStack = class_1799.method_7915((class_2487)stackTag.method_10562("Stack"));
            if (backpackStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public static List<class_1799> getBackpackContents(class_1799 stack) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_2499 tag = stack.method_7948().method_10554("Inventory", 10);
        for (class_2520 element : tag) {
            class_2487 stackTag = (class_2487)element;
            class_1799 backpackStack = class_1799.method_7915((class_2487)stackTag.method_10562("Stack"));
            stacks.add(backpackStack);
        }
        return stacks;
    }

    public static void wipeBackpack(class_1799 stack) {
        stack.method_7948().method_10551("Inventory");
    }

    public static class_2960 id(String name) {
        return new class_2960("inmis", name);
    }
}

