/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.util;

import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.base.DataColor;
import java.util.Arrays;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.ArmorStandItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BookItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFrameItem;
import net.minecraft.item.Items;
import net.minecraft.item.MinecartItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.tileentity.LockableLootTileEntity;

public class ItemUtils {
    public static DataColor getColorTag(DataItem dataItem) {
        Item item = dataItem.getItem().getItem();
        if (ItemUtils.isPotion(dataItem)) {
            return dataItem.getTag().getPotionColor();
        }
        if (item instanceof FilledMapItem) {
            return dataItem.getTag().getDisplay().getMapColor();
        }
        return dataItem.getTag().getDisplay().getColor();
    }

    public static boolean isColorable(DataItem dataItem) {
        Item item = dataItem.getItem().getItem();
        return item instanceof IDyeableArmorItem || ItemUtils.hasCustomPotionEffects(dataItem) || item == Items.field_151098_aY;
    }

    public static boolean isPotion(DataItem dataItem) {
        return dataItem.getItem().getItem() instanceof PotionItem;
    }

    public static boolean hasCustomPotionEffects(DataItem dataItem) {
        return ItemUtils.isPotion(dataItem) || dataItem.getItem().getItem() instanceof TippedArrowItem;
    }

    public static boolean hasEffects(DataItem dataItem) {
        return dataItem.getItem().getItem() instanceof SuspiciousStewItem;
    }

    public static boolean isLockableItem(DataItem dataItem) {
        Item item = dataItem.getItem().getItem();
        if (item instanceof BlockItem) {
            BlockItem b = (BlockItem)item;
            return b.func_179223_d().createTileEntity(b.func_179223_d().func_176223_P(), null) instanceof LockableLootTileEntity;
        }
        return false;
    }

    public static boolean isEntityItem(DataItem dataItem) {
        Item item = dataItem.getItem().getItem();
        return item instanceof SpawnEggItem || item instanceof ItemFrameItem || item instanceof ArmorStandItem || item instanceof MinecartItem;
    }

    public static boolean isBlockItem(DataItem dataItem) {
        return dataItem.getItem().isBlockItem();
    }

    public static boolean isTool(DataItem dataItem) {
        return dataItem.getItem().getItem() instanceof BlockItem;
    }

    public static boolean isEnchantable(DataItem dataItem) {
        Item item = dataItem.getItem().getItem();
        return dataItem.getItem().getItem().func_77616_k(dataItem.getItemStack()) || Arrays.stream(EnchantmentType.values()).anyMatch(enchantmentType -> enchantmentType.func_77557_a(item));
    }

    public static boolean isEnchantmentStorage(DataItem dataItem) {
        Item item = dataItem.getItem().getItem();
        return item instanceof BookItem || item instanceof EnchantedBookItem;
    }
}

