/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.util.GuiUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class ItemRendererUtils {
    private final ItemRenderer itemRenderer;

    public void renderItemIntoGUI(ItemStack stack, int x, int y, float xRot, float yRot) {
        this.renderItemModelIntoGUI(stack, x, y, xRot, yRot, this.itemRenderer.func_184393_a(stack, null, null));
    }

    public static void renderFormattedItemNBT(MatrixStack matrix, DataItem item, int mouseX, int mouseY, int width, int height, int maxTextWidth, FontRenderer font) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        ITextComponent formatted = (Minecraft.func_71410_x().field_71474_y.field_82882_x ? item : item.getTag()).getPrettyDisplay(" ", 0);
        list.add(formatted);
        int w = font.func_238414_a_((ITextProperties)formatted);
        if (w < maxTextWidth) {
            maxTextWidth = w - 5;
        }
        GuiUtil.drawHoveringText((ItemStack)item.getItemStack(), (MatrixStack)matrix, list, (int)mouseX, (int)mouseY, (int)width, (int)height, (int)maxTextWidth, (FontRenderer)font);
    }

    public TextureManager getTextureManager() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    protected void renderItemModelIntoGUI(ItemStack stack, int x, int y, float xRot, float yRot, IBakedModel bakedmodel) {
        boolean flag;
        RenderSystem.pushMatrix();
        this.getTextureManager().func_110577_a(AtlasTexture.field_110575_b);
        this.getTextureManager().func_229267_b_(AtlasTexture.field_110575_b).setBlurMipmap(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setupGuiTransform(x, y, xRot, yRot, bakedmodel.func_177556_c());
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    private void setupGuiTransform(int xPosition, int yPosition, float xRotation, float yRotation, boolean isGui3d) {
        RenderSystem.translatef((float)xPosition, (float)yPosition, (float)(100.0f + this.itemRenderer.field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        RenderSystem.rotatef((float)xRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)yRotation, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_227689_c_((float)1.0f, (float)xRotation, (float)yRotation, (float)0.0f);
        if (isGui3d) {
            RenderSystem.enableLighting();
        } else {
            RenderSystem.disableLighting();
        }
    }

    public ItemRendererUtils(ItemRenderer itemRenderer) {
        this.itemRenderer = itemRenderer;
    }
}

