/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.util;

import com.google.common.collect.Lists;
import infinityitemeditor.data.tag.TagEffect;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class EffectUtils {
    private static final IFormattableTextComponent NO_EFFECT = new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY);

    public static TextComponent getText(TagEffect tag) {
        Effect effect = tag.getEffectId().getEffect();
        TranslationTextComponent component = new TranslationTextComponent(effect.func_76393_a());
        if ((Byte)tag.getAmplifier().get() > 0) {
            component = new TranslationTextComponent("potion.withAmplifier", new Object[]{component, I18n.func_188566_a((String)("potion.potency." + tag.getAmplifier().get())) ? new TranslationTextComponent("potion.potency." + tag.getAmplifier().get()) : new StringTextComponent(String.valueOf((Byte)tag.getAmplifier().get() + 1))});
        }
        if ((Integer)tag.getDuration().get() > 20) {
            component = new TranslationTextComponent("potion.withDuration", new Object[]{component, EffectUtils.formatDuration(tag)});
        }
        return (TextComponent)component.func_240699_a_(effect.func_220303_e().func_220306_a());
    }

    public static String formatDuration(TagEffect tag) {
        if (((Boolean)tag.getAmbient().get()).booleanValue()) {
            return "**:**";
        }
        int i = MathHelper.func_76141_d((float)((Integer)tag.getDuration().get()).intValue());
        return StringUtils.func_76337_a((int)i);
    }

    public static boolean belongsToNameSpace(Effect effect, String namespace) {
        return effect.getRegistryName().func_110624_b().equals(namespace);
    }

    public static ITextComponent[] getTooltip(TagEffect tag) {
        ArrayList list1 = Lists.newArrayList();
        if (tag.getEffectId().isDefault()) {
            return new ITextComponent[]{NO_EFFECT};
        }
        Effect effect = tag.getEffectId().getEffect();
        TextComponent component = EffectUtils.getText(tag);
        Map modifierMap = effect.func_111186_k();
        if (!modifierMap.isEmpty()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(component);
            list.add(StringTextComponent.field_240750_d_);
            list.add(new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
            for (Map.Entry pair : modifierMap.entrySet()) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getValue();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 >= 0.0) {
                    list.add(new TranslationTextComponent("attribute.modifier.plus." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(((Attribute)pair.getKey()).func_233754_c_())}).func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add(new TranslationTextComponent("attribute.modifier.take." + attributemodifier2.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(((Attribute)pair.getKey()).func_233754_c_())}).func_240699_a_(TextFormatting.RED));
            }
            return list.toArray(new ITextComponent[0]);
        }
        return new ITextComponent[]{component};
    }
}

