/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.util;

import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtils {
    @OnlyIn(value=Dist.CLIENT)
    public static int multiplyColor(int firstColor, int secondColor) {
        int i = (firstColor & 0xFF0000) >> 16;
        int j = (secondColor & 0xFF0000) >> 16;
        int k = (firstColor & 0xFF00) >> 8;
        int l = (secondColor & 0xFF00) >> 8;
        int i1 = (firstColor & 0xFF) >> 0;
        int j1 = (secondColor & 0xFF) >> 0;
        int k1 = (int)((float)i * (float)j / 255.0f);
        int l1 = (int)((float)k * (float)l / 255.0f);
        int i2 = (int)((float)i1 * (float)j1 / 255.0f);
        return firstColor & 0xFF000000 | k1 << 16 | l1 << 8 | i2;
    }

    public static int mcHSVtoRGB(float hue, float saturation, float value) {
        return MathHelper.func_181758_c((float)hue, (float)saturation, (float)value);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        return java.awt.Color.HSBtoRGB(hue, saturation, brightness);
    }

    public static class Color
    extends Number
    implements Comparable<Integer> {
        protected int argb;

        public Color(int color) {
            this.setInt(color);
        }

        public Color(int r, int g, int b) {
            this.setInt(0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
        }

        public Color(int a, int r, int g, int b) {
            this.setARGB(a, r, g, b);
        }

        public static Color fromHSV(float hue, float saturation, float value) {
            return new Color(ColorUtils.mcHSVtoRGB(hue, saturation, value));
        }

        public static Color fromHSB(float hue, float saturation, float brightness) {
            return new Color(ColorUtils.HSBtoRGB(hue, saturation, brightness));
        }

        public Color setRGB(int r, int g, int b) {
            return this.setInt(this.argb & 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
        }

        public Color setARGB(int a, int r, int g, int b) {
            return this.setInt((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
        }

        public int getAlpha() {
            return this.argb >> 24 & 0xFF;
        }

        public Color setAlpha(int alpha) {
            return this.setInt((alpha & 0xFF) << 24 | this.argb & 0xFFFFFF);
        }

        public int getRed() {
            return this.argb >> 16 & 0xFF;
        }

        public Color setRed(int red) {
            return this.setInt((red & 0xFF) << 16 | this.argb & 0xFF00FFFF);
        }

        public int getGreen() {
            return this.argb >> 8 & 0xFF;
        }

        public Color setGreen(int green) {
            return this.setInt((green & 0xFF) << 8 | this.argb & 0xFFFF00FF);
        }

        public int getBlue() {
            return this.argb & 0xFF;
        }

        public Color setBlue(int blue) {
            return this.setInt(blue & 0xFF | this.argb & 0xFFFFFF00);
        }

        public int getInt() {
            return this.argb;
        }

        public Color setInt(int color) {
            this.argb = color;
            return this;
        }

        public Color hueShift() {
            int r = this.getRed();
            int g = this.getGreen();
            int b = this.getBlue();
            if (r == g && r == b) {
                return this;
            }
            int min = Math.min(r, Math.min(g, b));
            int max = Math.max(r, Math.max(g, b));
            if (r == max && g != max) {
                if (b == min) {
                    this.setGreen(g + 1);
                } else {
                    this.setBlue(b - 1);
                }
            } else if (g == max && b != max) {
                if (r == min) {
                    this.setBlue(b + 1);
                } else {
                    this.setRed(r - 1);
                }
            } else if (b == max && r != max) {
                if (g == min) {
                    this.setRed(r + 1);
                } else {
                    this.setGreen(g - 1);
                }
            }
            return this;
        }

        public int getPossibleHueShifts() {
            int r = this.getRed();
            int g = this.getGreen();
            int b = this.getBlue();
            int min = Math.min(r, Math.min(g, b));
            int max = Math.max(r, Math.max(g, b));
            return max - min;
        }

        public float getHue() {
            float max;
            float b;
            float g;
            float r = this.getRed();
            float min = Math.min(r, Math.min(g = (float)this.getGreen(), b = (float)this.getBlue()));
            if (min == (max = Math.max(r, Math.max(g, b)))) {
                return 0.0f;
            }
            float res = r == max ? (g - b) / (r - min) : (g == max ? 2.0f + (b - r) / (g - min) : 4.0f + (r - g) / (b - min));
            return res < 0.0f ? 1.0f + res : (res /= 6.0f);
        }

        public float[] getHSB() {
            return java.awt.Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), null);
        }

        public float getHSBSaturation() {
            return this.getHSB()[1];
        }

        public float getHSVSaturation() {
            float r = (float)this.getRed() / 255.0f;
            float g = (float)this.getGreen() / 255.0f;
            float b = (float)this.getBlue() / 255.0f;
            float min = Math.min(r, Math.min(g, b));
            float max = Math.max(r, Math.max(g, b));
            float delta = max - min;
            return delta == 0.0f ? 0.0f : 1.0f - Math.abs(min + max - 1.0f);
        }

        public float getLightness() {
            float r = this.getRed();
            float g = this.getGreen();
            float b = this.getBlue();
            float min = Math.min(r, Math.min(g, b));
            float max = Math.max(r, Math.max(g, b));
            return (min + max) / 510.0f;
        }

        public float getValue() {
            float r = this.getRed();
            float g = this.getGreen();
            float b = this.getBlue();
            float max = Math.max(r, Math.max(g, b));
            return max / 255.0f;
        }

        public Color setValue(float value) {
            float r = this.getRed();
            float g = this.getGreen();
            float b = this.getBlue();
            float max = Math.max(r, Math.max(g, b));
            float v = max / 255.0f;
            float f = value / v;
            this.setRed((int)(r * f));
            this.setGreen((int)(g * f));
            this.setBlue((int)(b * f));
            return this;
        }

        public String getHexString() {
            return String.format("#%06X", this.getInt() & 0xFFFFFF);
        }

        public String getHexStringWithAlpha() {
            return String.format("#%08X", this.getInt());
        }

        public Color copy() {
            return new Color(this.argb);
        }

        @Override
        public int compareTo(Integer o) {
            return Integer.compare(this.getInt(), o);
        }

        @Override
        public int intValue() {
            return this.getInt();
        }

        @Override
        public long longValue() {
            return this.getInt();
        }

        @Override
        public float floatValue() {
            return this.getInt();
        }

        @Override
        public double doubleValue() {
            return this.getInt();
        }

        public String toString() {
            return "Color[A:" + this.getAlpha() + ",R:" + this.getRed() + ",G:" + this.getGreen() + ",B:" + this.getBlue() + "]";
        }

        public net.minecraft.util.text.Color toMcColor() {
            return net.minecraft.util.text.Color.func_240743_a_((int)this.argb);
        }
    }
}

