/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.tab;

import infinityitemeditor.config.Config;
import infinityitemeditor.tab.TabCreative;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class TabNearbyBlocks
extends TabCreative {
    public TabNearbyBlocks() {
        super("nearbyblocks");
    }

    public void func_78018_a(NonNullList<ItemStack> items) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        ClientPlayerEntity player = mc.field_71439_g;
        BlockPos playerPos = new BlockPos(player.func_213303_ch());
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        int radius = (Integer)Config.NEARBYBLOCKS_TAB_RADIUS.get();
        int diameter = radius * 2;
        BlockPos original = playerPos.func_177971_a(new Vector3i(-radius, -radius, -radius));
        for (int x = 0; x < diameter; ++x) {
            for (int y = 0; y < diameter; ++y) {
                if (y > world.func_230315_m_().func_241513_m_() || y < 0) continue;
                for (int z = 0; z < diameter; ++z) {
                    BlockPos pos = new BlockPos((Vector3i)original).func_177971_a(new Vector3i(x, y, z));
                    BlockState state = world.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    Item item = block.func_199767_j();
                    if (block == Blocks.field_150357_h) continue;
                    if (block instanceof FlowingFluidBlock) {
                        FlowingFluidBlock fluidBlock = (FlowingFluidBlock)block;
                        FluidState fluidState = fluidBlock.func_204507_t(state);
                        if (fluidState.func_206882_g() != 8) continue;
                        FlowingFluid fluid = fluidBlock.getFluid();
                        item = fluid.func_204524_b();
                    }
                    if (item == Items.field_190931_a) continue;
                    if (block.hasTileEntity(state)) {
                        TileEntity te = world.func_175625_s(pos);
                        ItemStack stack = new ItemStack((IItemProvider)item);
                        mc.func_184119_a(stack, te);
                        boolean found = false;
                        for (ItemStack ex : items) {
                            if (!ex.equals(stack, false)) continue;
                            found = true;
                            if (ex.func_190916_E() >= 64) break;
                            ex.func_190920_e(ex.func_190916_E() + 1);
                            break;
                        }
                        if (found) continue;
                        items.add((Object)stack);
                        continue;
                    }
                    Integer value = map.putIfAbsent(item, 1);
                    if (value == null) continue;
                    map.put(item, value + 1);
                }
            }
        }
        LinkedList entries = new LinkedList(map.entrySet());
        entries.sort((entry1, entry2) -> ((Integer)entry1.getValue()).compareTo((Integer)entry2.getValue()));
        if (((Boolean)Config.NEARBYBLOCKS_TAB_MULTIPLESTACKS.get()).booleanValue()) {
            entries.forEach(entry -> {
                Item item = ((Item)entry.getKey()).func_199767_j();
                int count = (Integer)entry.getValue();
                if (count <= 64) {
                    items.add((Object)new ItemStack((IItemProvider)item, count));
                } else {
                    int div = count / 64;
                    int rem = count % 64;
                    for (int i = 0; i < div; ++i) {
                        items.add((Object)new ItemStack((IItemProvider)item, 64));
                    }
                    if (rem > 0) {
                        items.add((Object)new ItemStack((IItemProvider)item, rem));
                    }
                }
            });
        } else {
            entries.forEach(entry -> {
                Item item = ((Item)entry.getKey()).func_199767_j();
                int count = (Integer)entry.getValue();
                items.add((Object)new ItemStack((IItemProvider)item, Math.min(64, count)));
            });
        }
    }

    public ItemStack func_78016_d() {
        return new ItemStack((IItemProvider)Blocks.field_192437_dL);
    }
}

