/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.styles;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.screen.ParentScreen;
import infinityitemeditor.styles.IStyledSlider;
import infinityitemeditor.styles.IStyledWidget;
import infinityitemeditor.styles.Style;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;

public class StyleSpectrum
implements Style {
    private int spectrumTick = 0;
    private static final ColorUtils.Color color = new ColorUtils.Color(-65536);
    private static final ColorUtils.Color inactive = new ColorUtils.Color(-2293539);
    private static final ColorUtils.Color hovered = new ColorUtils.Color(-26368);

    @Override
    public ColorUtils.Color getMainColor() {
        return color.copy();
    }

    @Override
    public void update() {
        ++this.spectrumTick;
        this.spectrumTick %= 5;
        if (this.spectrumTick == 0) {
            color.hueShift();
            inactive.hueShift();
            hovered.hueShift();
        }
    }

    @Override
    public void renderBackground(MatrixStack matrix, ParentScreen screen) {
        GuiUtil.fillVerticalGradient(screen, 0, 0, screen.field_230708_k_, screen.field_230709_l_, -1072689136, -804253680);
    }

    @Override
    public void renderButton(MatrixStack matrix, IStyledWidget button, int mouseX, int mouseY, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        int j = this.getFGColor(button.getWidget()).getInt();
        GuiUtil.drawFrame(matrix, button.getWidget().field_230690_l_, button.getWidget().field_230691_m_, button.getWidget().field_230690_l_ + button.getWidget().func_230998_h_(), button.getWidget().field_230691_m_ + button.getWidget().func_238483_d_(), 1, new ColorUtils.Color(j));
        button.renderBackground(matrix, mc, mouseX, mouseY);
        String buttonText = button.getWidget().func_230458_i_().getString();
        int strWidth = mc.field_71466_p.func_78256_a(buttonText);
        int ellipsisWidth = mc.field_71466_p.func_78256_a("...");
        if (strWidth > button.getWidget().func_230998_h_() - 6 && strWidth > ellipsisWidth) {
            buttonText = mc.field_71466_p.func_238412_a_(buttonText, button.getWidget().func_230998_h_() - 6 - ellipsisWidth).trim() + "...";
        }
        button.getWidget();
        Widget.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)buttonText, (int)(button.getWidget().field_230690_l_ + button.getWidget().func_230998_h_() / 2), (int)(button.getWidget().field_230691_m_ + (button.getWidget().func_238483_d_() - 8) / 2), (int)(j | MathHelper.func_76123_f((float)(alpha * 255.0f)) << 24));
        button.getWidget();
        Widget.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)buttonText, (int)(button.getWidget().field_230690_l_ + button.getWidget().func_230998_h_() / 2), (int)(button.getWidget().field_230691_m_ + (button.getWidget().func_238483_d_() - 8) / 2), (int)this.getMainColor().getInt());
    }

    @Override
    public void renderSlider(MatrixStack matrix, IStyledSlider<?> slider, int mouseX, int mouseY) {
        int x = slider.getWidget().field_230690_l_ + 1 + (int)((float)(slider.getWidget().func_230998_h_() - 3) * (((Number)slider.getValue()).floatValue() - ((Number)slider.getMin()).floatValue()) / (((Number)slider.getMax()).floatValue() - ((Number)slider.getMin()).floatValue()));
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)(slider.getWidget().field_230691_m_ + 3), (int)(x + 1), (int)(slider.getWidget().field_230691_m_ + slider.getWidget().func_238483_d_() - 3), (int)this.getMainColor().getInt());
    }

    @Override
    public ColorUtils.Color getFGColor(Widget widget) {
        return this.getFGColor(widget.field_230693_o_, widget.func_230449_g_());
    }

    @Override
    public ColorUtils.Color getFGColor(boolean active, boolean hovered) {
        if (!active) {
            return inactive.copy();
        }
        if (hovered) {
            return StyleSpectrum.hovered.copy();
        }
        return this.getMainColor();
    }
}

