/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.styles;

import infinityitemeditor.config.Config;
import infinityitemeditor.styles.Style;
import infinityitemeditor.styles.StyleSpectrum;
import infinityitemeditor.styles.StyleVanilla;

public class StyleManager {
    private static int currentID = -1;
    private static Style currentStyle;

    public static Style getCurrentStyle() {
        if (currentStyle == null) {
            StyleManager.setCurrentStyle(currentID == -1 ? 0 : currentID);
        }
        return currentStyle;
    }

    private static void setCurrentStyle(Style style) {
        if (style != null) {
            currentStyle = style;
        }
    }

    public static void setCurrentStyle(int id) {
        if (currentID == -1 || currentID != id) {
            StyleManager.setCurrentStyle(id == 0 ? new StyleVanilla() : new StyleSpectrum());
            currentID = id;
        }
    }

    public static void loadConfig() {
        StyleManager.setCurrentStyle((Integer)Config.ACTIVESTYLE.get());
    }

    public static void setNext() {
        StyleManager.setCurrentStyle((currentID + 1) % 2);
    }
}

