/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.styles.StyleVanilla;
import infinityitemeditor.util.GuiUtil;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StyledTextField
extends Widget
implements IRenderable,
IGuiEventListener {
    private final FontRenderer fontRenderer;
    protected String text = "";
    protected String hint = null;
    protected int maxStringLength = 32;
    private int cursorCounter;
    private boolean canLoseFocus = true;
    private boolean isEnabled = true;
    private boolean shiftDown;
    private int lineScrollOffset;
    protected int cursorPosition;
    protected int selectionEnd;
    private String suggestion;
    private Consumer<String> guiResponder;
    protected Predicate<String> validator = s -> true;
    private BiFunction<String, Integer, String> textFormatter = (p_195610_0_, p_195610_1_) -> p_195610_0_;

    public StyledTextField(FontRenderer font, int x, int y, int width, int height, String msg) {
        this(font, x, y, width, height, null, msg);
    }

    public StyledTextField(FontRenderer fontIn, int x, int y, int width, int height, @Nullable StyledTextField old, String msg) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(msg));
        this.fontRenderer = fontIn;
        if (old != null) {
            this.setText(old.getText());
        }
    }

    public void setGuiResponder(Consumer<String> responder) {
        this.guiResponder = responder;
    }

    public void setTextFormatter(BiFunction<String, Integer, String> formatter) {
        this.textFormatter = formatter;
    }

    public void tick() {
        ++this.cursorCounter;
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.triggerResponder(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void setValidator(Predicate<String> p_200675_1_) {
        this.validator = p_200675_1_;
    }

    public void writeText(String textToWrite) {
        int l;
        String s = "";
        String s1 = SharedConstants.func_71565_a((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (!this.text.isEmpty()) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        if (this.validator.test(s)) {
            this.text = s;
            this.setCursorPos(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.triggerResponder(this.text);
        }
    }

    protected void triggerResponder(String p_212951_1_) {
        if (this.guiResponder != null) {
            this.guiResponder.accept(p_212951_1_);
        }
        this.field_230696_r_ = Util.func_211177_b() + 500L;
    }

    private void delete(int p_212950_1_) {
        if (Screen.func_231172_r_()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean flag = num < 0;
            int i = flag ? this.cursorPosition + num : this.cursorPosition;
            int j = flag ? this.cursorPosition : this.cursorPosition + num;
            String s = "";
            if (i >= 0) {
                s = this.text.substring(0, i);
            }
            if (j < this.text.length()) {
                s = s + this.text.substring(j);
            }
            if (this.validator.test(s)) {
                this.text = s;
                if (flag) {
                    this.moveCursorBy(num);
                }
                this.triggerResponder(this.text);
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.cursorPosition + num);
    }

    public void setCursorPosition(int pos) {
        this.setCursorPos(pos);
        if (!this.shiftDown) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.triggerResponder(this.text);
    }

    public void setCursorPos(int pos) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    public boolean func_231046_a_(int key1, int key2, int key3) {
        if (!this.getActive()) {
            return false;
        }
        this.shiftDown = Screen.func_231173_s_();
        if (Screen.func_231170_j_((int)key1)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.func_231169_i_((int)key1)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            return true;
        }
        if (Screen.func_231168_h_((int)key1)) {
            if (this.isEnabled) {
                this.writeText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            return true;
        }
        if (Screen.func_231166_g_((int)key1)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            if (this.isEnabled) {
                this.writeText("");
            }
            return true;
        }
        switch (key1) {
            case 259: {
                if (this.isEnabled) {
                    this.shiftDown = false;
                    this.delete(-1);
                    this.shiftDown = Screen.func_231173_s_();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.isEnabled) {
                    this.shiftDown = false;
                    this.delete(1);
                    this.shiftDown = Screen.func_231173_s_();
                }
                return true;
            }
            case 262: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.func_231172_r_()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean getActive() {
        return this.getVisible() && this.func_230999_j_() && this.isEnabled();
    }

    public boolean func_231042_a_(char char1, int char2) {
        if (!this.getActive()) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)char1)) {
            if (this.isEnabled) {
                this.writeText(Character.toString(char1));
            }
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        if (!this.getVisible()) {
            return false;
        }
        boolean bl = flag = mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_);
        if (this.canLoseFocus) {
            this.func_230996_d_(flag);
        }
        if (this.func_230999_j_() && flag && mouseButton == 0) {
            int i = MathHelper.func_76128_c((double)mouseX) - this.field_230690_l_;
            if (this.getEnableBackgroundDrawing()) {
                i -= 4;
            }
            String s = this.fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            this.setCursorPosition(this.fontRenderer.func_238412_a_(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.getVisible()) {
            if (this.getEnableBackgroundDrawing()) {
                if (StyleManager.getCurrentStyle() instanceof StyleVanilla) {
                    StyledTextField.func_238467_a_((MatrixStack)matrix, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)StyleManager.getCurrentStyle().getMainColor().getInt());
                    StyledTextField.func_238467_a_((MatrixStack)matrix, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-16777216);
                } else {
                    GuiUtil.drawFrame(matrix, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 1, StyleManager.getCurrentStyle().getMainColor());
                }
            }
            int color = StyleManager.getCurrentStyle().getFGColor(this).getInt();
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            String renderString = this.fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            boolean flag = j >= 0 && j <= renderString.length();
            boolean flag1 = this.func_230999_j_() && this.cursorCounter / 6 % 2 == 0 && flag;
            int l = this.getEnableBackgroundDrawing() ? this.field_230690_l_ + 4 : this.field_230690_l_;
            int i1 = this.getEnableBackgroundDrawing() ? this.field_230691_m_ + (this.field_230689_k_ - 8) / 2 : this.field_230691_m_;
            int j1 = l;
            if (k > renderString.length()) {
                k = renderString.length();
            }
            if (!renderString.isEmpty()) {
                String s1 = flag ? renderString.substring(0, j) : renderString;
                j1 = this.fontRenderer.func_238405_a_(matrix, this.textFormatter.apply(s1, this.lineScrollOffset), (float)l, (float)i1, color);
            }
            boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.field_230688_j_ : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!renderString.isEmpty() && flag && j < renderString.length()) {
                this.fontRenderer.func_238405_a_(matrix, this.textFormatter.apply(renderString.substring(j), this.cursorPosition), (float)j1, (float)i1, color);
            }
            if (!flag2 && this.suggestion != null) {
                this.fontRenderer.func_238405_a_(matrix, this.suggestion, (float)(k1 - 1), (float)i1, -8355712);
            }
            if (flag1) {
                if (flag2) {
                    AbstractGui.func_238467_a_((MatrixStack)matrix, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
                } else {
                    this.fontRenderer.func_238405_a_(matrix, "_", (float)k1, (float)i1, color);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.func_78256_a(renderString.substring(0, k));
                this.drawSelectionBox(k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
            if (this.text.length() == 0 && this.hint != null) {
                this.fontRenderer.func_238405_a_(matrix, this.hint, (float)j1, (float)i1, color);
            }
        }
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.field_230690_l_ + this.field_230688_j_) {
            endX = this.field_230690_l_ + this.field_230688_j_;
        }
        if (startX > this.field_230690_l_ + this.field_230688_j_) {
            startX = this.field_230690_l_ + this.field_230688_j_;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_225582_a_((double)startX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)endY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)endX, (double)startY, 0.0).func_181675_d();
        bufferbuilder.func_225582_a_((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.triggerResponder(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    private boolean getEnableBackgroundDrawing() {
        return true;
    }

    public boolean func_231049_c__(boolean p_changeFocus_1_) {
        return this.field_230694_p_ && this.isEnabled && super.func_231049_c__(p_changeFocus_1_);
    }

    protected void func_230996_d_(boolean p_230996_1_) {
        super.func_230996_d_(p_230996_1_);
    }

    public boolean func_231047_b_(double p_isMouseOver_1_, double p_isMouseOver_3_) {
        return this.field_230694_p_ && p_isMouseOver_1_ >= (double)this.field_230690_l_ && p_isMouseOver_1_ < (double)(this.field_230690_l_ + this.field_230688_j_) && p_isMouseOver_3_ >= (double)this.field_230691_m_ && p_isMouseOver_3_ < (double)(this.field_230691_m_ + this.field_230689_k_);
    }

    protected void func_230995_c_(boolean p_onFocusedChanged_1_) {
        if (p_onFocusedChanged_1_) {
            this.cursorCounter = 0;
        }
    }

    private boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public int getAdjustedWidth() {
        return this.getEnableBackgroundDrawing() ? this.field_230688_j_ - 8 : this.field_230688_j_;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        this.selectionEnd = MathHelper.func_76125_a((int)position, (int)0, (int)i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.func_238412_a_(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.func_238413_a_(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)i);
        }
    }

    public void setCanLoseFocus(boolean canLoseFocusIn) {
        this.canLoseFocus = canLoseFocusIn;
    }

    public boolean getVisible() {
        return this.field_230694_p_;
    }

    public void setVisible(boolean isVisible) {
        this.field_230694_p_ = isVisible;
    }

    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }
}

