/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.DataString;
import infinityitemeditor.data.base.DataTextComponent;
import infinityitemeditor.screen.DataController;
import infinityitemeditor.screen.widgets.StyledTextField;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.StringTextComponent;

public class StyledDataTextField
extends StyledTextField
implements DataController {
    private final Data<?, StringNBT> data;
    private boolean isResourceLocationField = false;

    public StyledDataTextField(FontRenderer fontIn, int x, int y, int width, int height, Data<?, StringNBT> data) {
        super(fontIn, x, y, width, height, data.getNBT().func_150285_a_());
        this.data = data;
        if (data instanceof DataTextComponent) {
            DataTextComponent dataT = (DataTextComponent)data;
            this.text = dataT.getFormatted();
        } else if (data instanceof DataString) {
            DataString dataS = (DataString)data;
            this.text = (String)dataS.get();
        }
        this.setMaxStringLength(1000);
    }

    @Override
    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.setTag(this.text.substring(0, length));
            this.triggerResponder(this.text);
        }
    }

    @Override
    public void writeText(String textToWrite) {
        int l;
        String s = "";
        String s1 = SharedConstants.func_71565_a((String)textToWrite);
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (!this.text.isEmpty()) {
            s = s + this.text.substring(0, i);
        }
        if (k < s1.length()) {
            s = s + s1.substring(0, k);
            l = k;
        } else {
            s = s + s1;
            l = s1.length();
        }
        if (!this.text.isEmpty() && j < this.text.length()) {
            s = s + this.text.substring(j);
        }
        if (this.validator.test(s)) {
            this.setTag(s);
            this.setCursorPos(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.triggerResponder(this.text);
        }
    }

    public void setIsResourceLocationField(boolean bool) {
        this.isResourceLocationField = bool;
    }

    @Override
    public boolean func_231042_a_(char char1, int char2) {
        if (this.isResourceLocationField && !ResourceLocation.func_240909_b_((char)char1)) {
            return false;
        }
        return super.func_231042_a_(char1, char2);
    }

    @Override
    public void deleteFromCursor(int num) {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.selectionEnd != this.cursorPosition) {
            this.writeText("");
        } else {
            boolean flag = num < 0;
            int i = flag ? this.cursorPosition + num : this.cursorPosition;
            int j = flag ? this.cursorPosition : this.cursorPosition + num;
            String s = "";
            if (i >= 0) {
                s = this.text.substring(0, i);
            }
            if (j < this.text.length()) {
                s = s + this.text.substring(j);
            }
            if (this.validator.test(s)) {
                this.setTag(s);
                if (flag) {
                    this.moveCursorBy(num);
                }
                this.triggerResponder(this.text);
            }
        }
    }

    @Override
    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.setTag(textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn);
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.triggerResponder(textIn);
        }
    }

    private void setTag(String text) {
        if (this.data instanceof DataTextComponent) {
            DataTextComponent dataT = (DataTextComponent)this.data;
            dataT.set(new StringTextComponent(text));
            this.text = dataT.getFormatted();
        } else if (this.data instanceof DataString) {
            DataString dataS = (DataString)this.data;
            dataS.set(text);
            this.text = (String)dataS.get();
        }
    }

    @Override
    public Data<?, ?> getDataTag() {
        return this.data;
    }
}

