/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.NumberRangeFloat;
import infinityitemeditor.styles.IStyledSlider;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.styles.StyleSpectrum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SliderTagFloat
extends Widget
implements IStyledSlider<Float> {
    private final NumberRangeFloat range;
    public String display;
    public boolean drawString;

    public SliderTagFloat(int x, int y, int width, int height, String display, NumberRangeFloat range) {
        this(x, y, width, height, display, true, range);
    }

    public SliderTagFloat(int x, int y, int width, int height, NumberRangeFloat range) {
        this(x, y, width, height, "", true, range);
    }

    public SliderTagFloat(int x, int y, int width, int height, String display, boolean drawString, NumberRangeFloat range) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(display));
        this.display = display;
        this.drawString = drawString;
        this.range = range;
        this.func_238482_a_((ITextComponent)new StringTextComponent(drawString ? display + range.get() : ""));
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float p3) {
        StyleManager.getCurrentStyle().renderButton(matrix, this, mouseX, mouseY, p3);
    }

    private void setValueFromMouse(double mouseX) {
        float updateValue = StyleManager.getCurrentStyle() instanceof StyleSpectrum ? ((float)mouseX - ((float)this.field_230690_l_ + 1.0f)) / ((float)this.field_230688_j_ - 2.5f) : ((float)mouseX - (float)(this.field_230690_l_ + 4)) / (float)(this.field_230688_j_ - 8);
        float round = updateValue * (this.range.getMax() - this.range.getMin()) + this.range.getMin();
        this.setValue(round);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    public boolean func_231046_a_(int key1, int key2, int key3) {
        if (key1 == 263 && this.getValue().floatValue() > this.getMin().floatValue()) {
            this.range.set(Float.valueOf(((Float)this.range.get()).floatValue() - 1.0f));
            this.updateSlider();
            return true;
        }
        if (key1 == 262 && this.getValue().floatValue() < this.getMax().floatValue()) {
            this.range.set(Float.valueOf(((Float)this.range.get()).floatValue() + 1.0f));
            this.updateSlider();
            return true;
        }
        return false;
    }

    public void setValue(float value) {
        float old = this.getValue().floatValue();
        this.range.set(Float.valueOf(value));
        if (this.getValue().floatValue() != old) {
            this.updateSlider();
        }
    }

    public void updateSlider() {
        this.func_238482_a_((ITextComponent)new StringTextComponent(this.drawString ? this.display + this.getValue() : ""));
    }

    protected void func_230983_a_(double mouseX, double p_onDrag_3_, double p_onDrag_5_, double p_onDrag_7_) {
        this.setValueFromMouse(mouseX);
        super.func_230983_a_(mouseX, p_onDrag_3_, p_onDrag_5_, p_onDrag_7_);
    }

    public void func_230988_a_(SoundHandler soundHandler) {
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
    }

    public int getFGColor() {
        return StyleManager.getCurrentStyle().getFGColor(this).getInt();
    }

    @Override
    public Widget getWidget() {
        return this;
    }

    @Override
    public int getImageY(boolean b) {
        return 0;
    }

    @Override
    public int getOffsetBlit() {
        return 0;
    }

    @Override
    public void setHovered(boolean b) {
        this.field_230692_n_ = b;
    }

    @Override
    public void renderBackground(MatrixStack matrix, Minecraft mc, int mouseX, int mouseY) {
        if (!this.field_230694_p_) {
            return;
        }
        StyleManager.getCurrentStyle().renderSlider(matrix, this, mouseX, mouseY);
    }

    @Override
    public Float getValue() {
        return (Float)this.range.get();
    }

    @Override
    public Float getMin() {
        return Float.valueOf(this.range.getMin());
    }

    @Override
    public Float getMax() {
        return Float.valueOf(this.range.getMax());
    }
}

