/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.NumberRangeInt;
import infinityitemeditor.styles.IStyledSlider;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.styles.StyleSpectrum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SliderTag
extends Widget
implements IStyledSlider<Integer> {
    private final NumberRangeInt range;
    public String display;
    public boolean drawString;

    public SliderTag(int x, int y, int width, int height, String display, NumberRangeInt range) {
        this(x, y, width, height, display, true, range);
    }

    public SliderTag(int x, int y, int width, int height, NumberRangeInt range) {
        this(x, y, width, height, "", true, range);
    }

    public SliderTag(int x, int y, int width, int height, String display, boolean drawString, NumberRangeInt range) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(display));
        this.display = display;
        this.drawString = drawString;
        this.range = range;
        this.func_238482_a_((ITextComponent)new StringTextComponent(drawString ? display + range.get() : ""));
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float p3) {
        this.updateSlider();
        StyleManager.getCurrentStyle().renderButton(matrix, this, mouseX, mouseY, p3);
    }

    private void setValueFromMouse(double mouseX) {
        double updateValue = StyleManager.getCurrentStyle() instanceof StyleSpectrum ? (mouseX - ((double)this.field_230690_l_ + 1.0)) / ((double)this.field_230688_j_ - 2.5) : (mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8);
        int round = (int)Math.round(updateValue * (double)(this.range.getMax() - this.range.getMin()) + (double)this.range.getMin());
        this.setValue(round);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    public boolean func_231046_a_(int key1, int key2, int key3) {
        if (key1 == 263 && this.getValue() > this.getMin()) {
            this.range.set(this.getValue() - 1);
            this.updateSlider();
            return true;
        }
        if (key1 == 262 && this.getValue() < this.getMax()) {
            this.range.set(this.getValue() + 1);
            this.updateSlider();
            return true;
        }
        return false;
    }

    public void setValue(int value) {
        int old = this.getValue();
        this.range.set(value);
        if (this.getValue() != old) {
            this.updateSlider();
        }
    }

    public void updateSlider() {
        this.func_238482_a_((ITextComponent)new StringTextComponent(this.drawString ? this.display + this.getValue() : ""));
    }

    protected void func_230983_a_(double mouseX, double p_onDrag_3_, double p_onDrag_5_, double p_onDrag_7_) {
        this.setValueFromMouse(mouseX);
        super.func_230983_a_(mouseX, p_onDrag_3_, p_onDrag_5_, p_onDrag_7_);
    }

    public void func_230988_a_(SoundHandler soundHandler) {
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
    }

    public int getFGColor() {
        return StyleManager.getCurrentStyle().getFGColor(this).getInt();
    }

    @Override
    public Widget getWidget() {
        return this;
    }

    @Override
    public int getImageY(boolean b) {
        return 0;
    }

    @Override
    public int getOffsetBlit() {
        return 0;
    }

    @Override
    public void setHovered(boolean b) {
        this.field_230692_n_ = b;
    }

    @Override
    public void renderBackground(MatrixStack matrix, Minecraft mc, int mouseX, int mouseY) {
        if (!this.field_230694_p_) {
            return;
        }
        StyleManager.getCurrentStyle().renderSlider(matrix, this, mouseX, mouseY);
    }

    @Override
    public Integer getValue() {
        return (Integer)this.range.get();
    }

    @Override
    public Integer getMin() {
        return this.range.getMin();
    }

    @Override
    public Integer getMax() {
        return this.range.getMax();
    }
}

