/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.base.DataColor;
import infinityitemeditor.styles.Style;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class HexField
extends Widget {
    private final FontRenderer fontRenderer;
    DataColor dataColor;
    public char[] digits;
    private final char[] allowed = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f'};
    private int cursorCounter;
    private final boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private final boolean enabled = true;
    private int cursorPosition;

    public HexField(FontRenderer font, int x, int y, int height, DataColor color) {
        super(x, y, font.func_78256_a("#FFFFFF") + 8, height, (ITextComponent)new StringTextComponent(""));
        this.dataColor = color;
        this.fontRenderer = font;
        this.digits = new char[]{'0', '0', '0', '0', '0', '0'};
        this.setValue(this.dataColor.getInt());
    }

    public static int getMax() {
        return 0xFFFFFF;
    }

    public static int getMin() {
        return 0;
    }

    public String getHexString() {
        return '#' + new String(this.digits);
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setDigit(int i, char c) {
        if (this.isAllowed(c)) {
            this.digits[i] = c;
        }
        this.dataColor.setInt(this.getDigitsValue());
    }

    public void setDigit(char c) {
        this.setDigit(this.cursorPosition, c);
    }

    private void setValue(int value) {
        value = 0xFFFFFF & value;
        String s = String.format("%06X", value);
        for (int i = 0; i < s.length(); ++i) {
            this.digits[i] = s.charAt(i);
        }
    }

    private int getDigitsValue() {
        try {
            return Integer.decode("#" + new String(this.digits));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isAllowed(char c) {
        for (char ch : this.allowed) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public void moveCursor(boolean right) {
        this.setCursorPosition(this.cursorPosition + (right ? 1 : -1));
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        int i = this.digits.length - 1;
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)i);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.digits.length - 1);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifier) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Screen.func_231169_i_((int)keyCode)) {
            mc.field_195559_v.func_197960_a(String.valueOf(this.digits));
            return true;
        }
        if (Screen.func_231168_h_((int)keyCode)) {
            try {
                int p = Integer.decode(mc.field_195559_v.func_197965_a());
                this.dataColor.setInt(p);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Screen.func_231166_g_((int)keyCode)) {
            mc.field_195559_v.func_197960_a(String.valueOf(this.digits));
            return true;
        }
        switch (keyCode) {
            case 263: {
                this.moveCursor(false);
                return true;
            }
            case 262: {
                this.moveCursor(true);
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifier);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (!this.isActive()) {
            return false;
        }
        if (this.isAllowed(typedChar)) {
            if (this.isEnabled()) {
                this.setDigit(Character.toUpperCase(typedChar));
                this.moveCursor(true);
            }
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this.field_230694_p_ && this.func_230999_j_() && this.isEnabled();
    }

    public boolean func_231049_c__(boolean p_changeFocus_1_) {
        return this.field_230694_p_ && this.isEnabled() && super.func_231049_c__(p_changeFocus_1_);
    }

    protected void func_230995_c_(boolean p_onFocusedChanged_1_) {
        if (p_onFocusedChanged_1_) {
            this.cursorCounter = 0;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        boolean bl = flag = mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_);
        if (this.canLoseFocus) {
            this.func_230996_d_(flag);
        }
        if (this.func_230999_j_() && flag && mouseButton == 0) {
            int i = (int)mouseX - this.field_230690_l_;
            ((Object)((Object)this)).getClass();
            String s = this.fontRenderer.func_238412_a_(this.getHexString(), this.func_230998_h_());
            this.setCursorPosition(this.fontRenderer.func_238412_a_(s, i -= 4).length());
            return true;
        }
        return false;
    }

    public void func_230431_b_(MatrixStack matrix, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Style style = StyleManager.getCurrentStyle();
        ColorUtils.Color color = style.getFGColor(this);
        if (this.getDigitsValue() != this.dataColor.getInt()) {
            this.setValue(this.dataColor.getInt());
        }
        if (this.getEnableBackgroundDrawing()) {
            GuiUtil.drawFrame(matrix, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 1, color);
        }
        int cursorPos = this.cursorPosition;
        String string = this.fontRenderer.func_238412_a_(this.getHexString(), this.func_230998_h_());
        boolean cursorFine = cursorPos >= 0 && cursorPos <= string.length();
        boolean displayCursor = this.func_230999_j_() && this.cursorCounter / 6 % 2 == 0 && cursorFine;
        ((Object)((Object)this)).getClass();
        int textX = this.field_230690_l_ + 4;
        ((Object)((Object)this)).getClass();
        int textY = this.field_230691_m_ + (this.field_230689_k_ - 8) / 2;
        int halfX = textX;
        if (!string.isEmpty()) {
            String halfString = cursorFine ? string.substring(0, cursorPos) : string;
            halfX = this.fontRenderer.func_238405_a_(matrix, halfString, (float)textX, (float)textY, this.dataColor.getInt()) - 1;
        }
        int cursorX = halfX + (int)Math.ceil(this.fontRenderer.func_78256_a("#"));
        if (!cursorFine) {
            int n = cursorX = cursorPos > 0 ? textX + this.field_230688_j_ : textX;
        }
        if (!string.isEmpty() && cursorFine && cursorPos < string.length()) {
            halfX = this.fontRenderer.func_238405_a_(matrix, string.substring(cursorPos), (float)halfX, (float)textY, this.dataColor.getInt());
        }
        if (displayCursor) {
            this.fontRenderer.func_238405_a_(matrix, "_", (float)cursorX, (float)textY, color.getInt());
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        ((Object)((Object)this)).getClass();
        return true;
    }

    public void func_230996_d_(boolean isFocusedIn) {
        super.func_230996_d_(isFocusedIn);
        if (isFocusedIn) {
            this.cursorCounter = 0;
        }
    }

    public int func_230998_h_() {
        return this.getEnableBackgroundDrawing() ? this.field_230688_j_ - 6 : this.field_230688_j_;
    }

    public void setCanLoseFocus(boolean canLoseFocusIn) {
        this.canLoseFocus = canLoseFocusIn;
    }

    public DataColor getDataColor() {
        return this.dataColor;
    }

    public boolean isEnabled() {
        ((Object)((Object)this)).getClass();
        return true;
    }
}

