/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.models;

import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.tag.TagEffect;
import infinityitemeditor.screen.models.EffectModifier;
import infinityitemeditor.screen.models.TagFilter;
import infinityitemeditor.screen.models.TagModifier;
import infinityitemeditor.screen.models.WheelType;
import infinityitemeditor.util.EffectUtils;
import java.util.Arrays;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class EffectWheelType
extends WheelType<TagEffect> {
    private static final TagFilter<TagEffect> BENEFICIAL = new TagFilter<TagEffect>(){

        @Override
        public TextComponent getName() {
            return new TranslationTextComponent("filter.effect.beneficial");
        }

        @Override
        public boolean shouldShow(DataItem item, TagEffect tag) {
            return tag.getEffectId().getEffect().func_188408_i();
        }

        public TagEffect[] filter(DataItem item, TagEffect[] tags) {
            return (TagEffect[])Arrays.stream(tags).filter(tag -> this.shouldShow(item, (TagEffect)tag)).toArray(TagEffect[]::new);
        }
    };
    private static final TagFilter<TagEffect> NEUTRAL = new TagFilter<TagEffect>(){

        @Override
        public TextComponent getName() {
            return new TranslationTextComponent("filter.effect.neutral");
        }

        @Override
        public boolean shouldShow(DataItem item, TagEffect tag) {
            return tag.getEffectId().getEffect().func_220303_e() == EffectType.NEUTRAL;
        }

        public TagEffect[] filter(DataItem item, TagEffect[] tags) {
            return (TagEffect[])Arrays.stream(tags).filter(tag -> this.shouldShow(item, (TagEffect)tag)).toArray(TagEffect[]::new);
        }
    };
    private static final TagFilter<TagEffect> HARMFUL = new TagFilter<TagEffect>(){

        @Override
        public TextComponent getName() {
            return new TranslationTextComponent("filter.effect.harmful");
        }

        @Override
        public boolean shouldShow(DataItem item, TagEffect tag) {
            return tag.getEffectId().getEffect().func_220303_e() == EffectType.HARMFUL;
        }

        public TagEffect[] filter(DataItem item, TagEffect[] tags) {
            return (TagEffect[])Arrays.stream(tags).filter(tag -> this.shouldShow(item, (TagEffect)tag)).toArray(TagEffect[]::new);
        }
    };
    private static final TagFilter<TagEffect> VANILLA = new TagFilter<TagEffect>(){

        @Override
        public TextComponent getName() {
            return new StringTextComponent("minecraft");
        }

        @Override
        public boolean shouldShow(DataItem item, TagEffect tag) {
            return EffectUtils.belongsToNameSpace(tag.getEffectId().getEffect(), "minecraft");
        }

        public TagEffect[] filter(DataItem item, TagEffect[] tags) {
            return (TagEffect[])Arrays.stream(tags).filter(tag -> this.shouldShow(item, (TagEffect)tag)).toArray(TagEffect[]::new);
        }
    };

    public EffectWheelType(DataItem dataItem) {
        super(dataItem, BENEFICIAL, NEUTRAL, HARMFUL, VANILLA);
    }

    @Override
    public TagModifier<TagEffect> getTagModifier() {
        return new EffectModifier();
    }

    public TagEffect[] newArray(int size) {
        return new TagEffect[size];
    }

    @Override
    public TagEffect clone(TagEffect tag) {
        return new TagEffect(tag.getNBT());
    }

    public TagEffect[] getAll() {
        return (TagEffect[])GameRegistry.findRegistry(Effect.class).getEntries().stream().map(TagEffect::new).toArray(this::newArray);
    }

    @Override
    public TextComponent displayTag(TagEffect tag) {
        return (TextComponent)tag.getPrettyDisplay("", 0);
    }

    @Override
    public ITextComponent[] tooltip(TagEffect tag) {
        return EffectUtils.getTooltip(tag);
    }
}

