/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.models;

import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.tag.TagAttributeModifier;
import infinityitemeditor.screen.models.AttributeTagModifier;
import infinityitemeditor.screen.models.TagFilter;
import infinityitemeditor.screen.models.TagModifier;
import infinityitemeditor.screen.models.WheelType;
import infinityitemeditor.util.AttributeUtils;
import java.util.Arrays;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class AttributeWheelType
extends WheelType<TagAttributeModifier> {
    private static final TagFilter<TagAttributeModifier> VANILLA = new TagFilter<TagAttributeModifier>(){

        @Override
        public TextComponent getName() {
            return new StringTextComponent("minecraft");
        }

        @Override
        public boolean shouldShow(DataItem item, TagAttributeModifier tag) {
            return AttributeUtils.belongsToNameSpace(tag.getAttribute(), "minecraft");
        }

        public TagAttributeModifier[] filter(DataItem item, TagAttributeModifier[] tags) {
            return (TagAttributeModifier[])Arrays.stream(tags).filter(tagAttributeModifier -> this.shouldShow(item, (TagAttributeModifier)tagAttributeModifier)).toArray(TagAttributeModifier[]::new);
        }
    };
    private static final TagFilter<TagAttributeModifier> FORGE = new TagFilter<TagAttributeModifier>(){

        @Override
        public TextComponent getName() {
            return new StringTextComponent("forge");
        }

        @Override
        public boolean shouldShow(DataItem item, TagAttributeModifier tag) {
            return AttributeUtils.belongsToNameSpace(tag.getAttribute(), "forge");
        }

        public TagAttributeModifier[] filter(DataItem item, TagAttributeModifier[] tags) {
            return (TagAttributeModifier[])Arrays.stream(tags).filter(tagAttributeModifier -> this.shouldShow(item, (TagAttributeModifier)tagAttributeModifier)).toArray(TagAttributeModifier[]::new);
        }
    };

    public AttributeWheelType(DataItem dataItem) {
        super(dataItem, VANILLA, FORGE);
    }

    @Override
    public TagModifier<TagAttributeModifier> getTagModifier() {
        return new AttributeTagModifier(this.dataItem);
    }

    public TagAttributeModifier[] newArray(int size) {
        return new TagAttributeModifier[size];
    }

    @Override
    public TagAttributeModifier clone(TagAttributeModifier tag) {
        return new TagAttributeModifier(tag.getNBT());
    }

    public TagAttributeModifier[] getAll() {
        return (TagAttributeModifier[])GameRegistry.findRegistry(Attribute.class).getEntries().stream().map(TagAttributeModifier::new).toArray(this::newArray);
    }

    @Override
    public TextComponent displayTag(TagAttributeModifier tag) {
        return AttributeUtils.getText(tag.getAttribute(), tag.createAttributeModifier());
    }

    @Override
    public ITextComponent[] tooltip(TagAttributeModifier tag) {
        return AttributeUtils.getTooltip(tag);
    }
}

