/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import infinityitemeditor.data.Data;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.tag.TagEffect;
import infinityitemeditor.data.tag.TagList;
import infinityitemeditor.screen.ParentItemScreen;
import infinityitemeditor.screen.models.TagFilter;
import infinityitemeditor.screen.models.TagModifier;
import infinityitemeditor.screen.models.WheelType;
import infinityitemeditor.screen.widgets.ScrollableScissorWindow;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.screen.widgets.StyledOptionSwitcher;
import infinityitemeditor.screen.widgets.StyledTextField;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import infinityitemeditor.util.TextComponentUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class WheelScreen<T extends Data<?, ?>>
extends ParentItemScreen {
    protected final String name;
    protected final WheelType<T> wheelType;
    protected final TagFilter<?>[] tagFilters;
    protected final TagModifier<T> tagModifier;
    protected final T[] allTags;
    protected final TagList<T> added;
    protected T hovered = null;
    protected ArrayList<T> filteredTags;
    private StyledOptionSwitcher filter;
    private StyledTextField searchField;
    private TagFilter<?> filteredFilter = WheelType.ALL;
    private String filteredString = "";
    private ScrollableScissorWindow addedWidgets;
    private Map<Widget, T> widgetTags;
    private int midX;
    private int midY;
    private double radius;
    private double radiusSquared;
    private int rotOff = 0;
    private int mouseDistSquared = 0;

    public WheelScreen(Screen lastScreen, String name, WheelType<T> wheelType, DataItem item, TagList<T> list) {
        super((ITextComponent)new TranslationTextComponent("gui." + name), lastScreen, item);
        this.name = "gui." + name;
        this.wheelType = wheelType;
        this.tagFilters = wheelType.getTagFilters();
        this.tagModifier = wheelType.getTagModifier();
        this.allTags = wheelType.getAll();
        this.filteredTags = new ArrayList(this.allTags.length);
        Collections.addAll(this.filteredTags, this.allTags);
        this.added = list;
        this.renderItem = false;
    }

    @Override
    public void reset(Widget w) {
        super.reset(w);
        this.addedWidgets.func_231039_at__().clear();
    }

    public void filter() {
        Data[] filtered;
        String newFilter = this.searchField.getText().toLowerCase();
        if (newFilter.equals(this.filteredString) && this.filter.getOption() == this.filteredFilter) {
            return;
        }
        this.filteredTags.clear();
        this.filteredFilter = (TagFilter)this.filter.getOption();
        this.filteredString = this.searchField.getText();
        for (Data tag : filtered = this.filteredFilter.filter(item, (Data[])this.allTags)) {
            if (!TextComponentUtils.getPlainText((ITextProperties)this.wheelType.displayTag(tag)).toLowerCase().contains(newFilter)) continue;
            this.filteredTags.add(tag);
        }
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        for (Widget w : this.tagModifier.widgets(this.field_230712_o_, this.field_230708_k_, this.field_230709_l_)) {
            this.func_230480_a_(w);
        }
        this.filter = (StyledOptionSwitcher)this.func_230480_a_((Widget)new StyledOptionSwitcher(10, 10, 100, 20, this.tagFilters, this.filteredFilter));
        this.searchField = (StyledTextField)this.func_230480_a_(new StyledTextField(this.field_230712_o_, 10, 35, 100, 20, this.filteredString));
        this.searchField.setHint(I18n.func_135052_a((String)"gui.wheel.search", (Object[])new Object[0]));
        this.addedWidgets = (ScrollableScissorWindow)this.func_230480_a_(new ScrollableScissorWindow(this.field_230708_k_ - 130, 50, 120, this.field_230709_l_ - 60, (ITextComponent)new TranslationTextComponent(this.name + ".added")));
        this.widgetTags = new HashMap<Widget, T>();
        for (Data tag : this.added) {
            this.addTag(tag);
        }
        this.midX = this.field_230708_k_ / 2;
        this.midY = this.field_230709_l_ / 2;
        this.radius = (double)this.field_230709_l_ / 3.0;
        this.radiusSquared = this.radius * this.radius;
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private void addTag(T tag) {
        StyledButton tagButton = new StyledButton(0, 0, 0, 20, TextComponentUtils.getPlainText((ITextProperties)this.wheelType.displayTag(tag)), this::removeTagByWidget);
        this.addedWidgets.getWidgets().add((Widget)tagButton);
        this.widgetTags.put((Widget)tagButton, tag);
    }

    private void removeTagByWidget(Widget w) {
        this.addedWidgets.getWidgets().remove(w);
        if (this.widgetTags.containsKey(w)) {
            this.added.remove((Data)this.widgetTags.get(w));
            this.widgetTags.remove(w);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (Math.abs((double)this.mouseDistSquared - this.radiusSquared) >= 3000.0) {
            ++this.rotOff;
        }
        this.filter();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.hovered != null) {
            T clicked = this.wheelType.clone(this.hovered);
            this.tagModifier.modify(clicked);
            this.addTag(clicked);
            this.added.add(clicked);
            return true;
        }
        return false;
    }

    @Override
    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.backRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        boolean hovering;
        super.mainRender(matrix, mouseX, mouseY, p3, color);
        this.hovered = null;
        this.addedWidgets.field_230694_p_ = !this.addedWidgets.func_231039_at__().isEmpty();
        int midDistX = this.midX - mouseX;
        int midDistY = this.midY - mouseY;
        this.mouseDistSquared = midDistX * midDistX + midDistY * midDistY;
        double angle = Math.PI * 2 / (double)this.filteredTags.size();
        double closestDistanceSquared = 2.147483647E9;
        boolean bl = hovering = Math.abs((double)this.mouseDistSquared - this.radiusSquared) < 3000.0;
        if (this.addedWidgets.field_230694_p_) {
            WheelScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)this.addedWidgets.func_230458_i_(), (int)this.addedWidgets.field_230690_l_, (int)(this.addedWidgets.field_230691_m_ - 10), (int)color.getInt());
        }
        for (int i = 0; i < this.filteredTags.size(); ++i) {
            double distY;
            double distX;
            double distSquared;
            Data tag = (Data)this.filteredTags.get(i);
            this.tagModifier.modify(tag);
            double angleI = ((double)this.rotOff + (hovering ? 0.0 : (double)p3)) * 0.01 + angle * (double)i - 1.5708;
            double x = (double)this.midX + this.radius * Math.cos(angleI);
            double y = (double)this.midY + this.radius * Math.sin(angleI);
            if (hovering && this.hovered == null && (distSquared = (distX = x - (double)mouseX) * distX + (distY = y - (double)mouseY) * distY) < 100.0 && distSquared < closestDistanceSquared) {
                closestDistanceSquared = distSquared;
                this.hovered = (Data)this.filteredTags.get(i);
            }
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)x, (double)y, (double)0.0);
            if (tag instanceof TagEffect) {
                TagEffect tagEffect = (TagEffect)tag;
                PotionSpriteUploader potionspriteuploader = this.field_230706_i_.func_213248_ap();
                Effect effect = tagEffect.getEffectId().getEffect();
                TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(effect);
                this.field_230706_i_.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
                WheelScreen.func_238470_a_((MatrixStack)matrix, (int)-9, (int)-9, (int)this.func_230927_p_(), (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            } else if (item.getItem().getItem() != Items.field_190931_a) {
                this.drawItemStack(item.getItemStack(), -8, -8, 0.0f, 0.0f, null);
            } else {
                WheelScreen.func_238467_a_((MatrixStack)matrix, (int)-1, (int)-1, (int)1, (int)1, (int)color.getInt());
            }
            RenderSystem.popMatrix();
        }
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.overlayRender(matrix, mouseX, mouseY, p3, color);
        double angle = Math.PI * 2 / (double)this.filteredTags.size();
        double closestDistanceSquared = 2.147483647E9;
        boolean hovering = Math.abs((double)this.mouseDistSquared - this.radiusSquared) < 3000.0;
        for (int i = 0; i < this.filteredTags.size(); ++i) {
            double distY;
            double distX;
            double distSquared;
            Data tag = (Data)this.filteredTags.get(i);
            this.tagModifier.modify(tag);
            double angleI = ((double)this.rotOff + (hovering ? 0.0 : (double)p3)) * 0.01 + angle * (double)i - 1.5708;
            double relX = this.radius * Math.cos(angleI);
            double relY = this.radius * Math.sin(angleI);
            double x = (double)this.midX + relX;
            double y = (double)this.midY + relY;
            if (hovering && this.hovered == null && (distSquared = (distX = x - (double)mouseX) * distX + (distY = y - (double)mouseY) * distY) < 100.0 && distSquared < closestDistanceSquared) {
                closestDistanceSquared = distSquared;
                this.hovered = (Data)this.filteredTags.get(i);
            }
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)x, (double)y, (double)300.0);
            IFormattableTextComponent component = this.wheelType.displayTag(tag).func_240703_c_(Style.field_240709_b_.func_240718_a_(StyleManager.getCurrentStyle().getFGColor(true, tag == this.hovered).toMcColor()));
            if (0.1 * Math.abs(relY) > Math.abs(relX)) {
                int textYOffset = relY < 0.0 ? -17 : 7;
                WheelScreen.func_238472_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)component, (int)0, (int)textYOffset, (int)color.getInt());
            } else if (relX < 0.0) {
                WheelScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)component, (int)(-10 - this.field_230712_o_.func_238414_a_((ITextProperties)component)), (int)-5, (int)color.getInt());
            } else {
                WheelScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)component, (int)10, (int)-5, (int)color.getInt());
            }
            RenderSystem.popMatrix();
        }
        if (this.hovered != null) {
            GuiUtil.addToolTip(matrix, (Screen)this, mouseX, mouseY, (ITextProperties[])this.wheelType.tooltip(this.hovered));
        } else {
            for (Widget w : this.addedWidgets.getWidgets()) {
                if (!w.func_230449_g_() || !this.widgetTags.containsKey(w)) continue;
                GuiUtil.addToolTip(matrix, (Screen)this, mouseX, mouseY, (ITextProperties[])this.wheelType.tooltip((Data)this.widgetTags.get(w)));
                return;
            }
        }
    }
}

