/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.base.DataString;
import infinityitemeditor.screen.ParentScreen;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TextEditorScreen
extends ParentScreen {
    private int cursor = 0;
    private final DataString text;
    private int cursorTicks = 0;
    private int preview = 0;

    public TextEditorScreen(Screen lastScreen) {
        this(lastScreen, new DataString(), true, true);
    }

    public TextEditorScreen(Screen lastScreen, DataString text, boolean plainText, boolean multiLine) {
        super((ITextComponent)new TranslationTextComponent("gui.texteditor"), lastScreen);
        this.text = text;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new StyledButton(15, 15, 60, 10, I18n.func_135052_a((String)"gui.texteditor.preview", (Object[])new Object[0]), b -> {
            this.preview = (this.preview + 1) % 3;
        }));
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.cursorTicks = (this.cursorTicks + 1) % 20;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scan, int modifier) {
        if (super.func_231046_a_(keyCode, scan, modifier)) {
            return true;
        }
        if (keyCode == 259 && ((String)this.text.get()).length() > 0) {
            String s = (String)this.text.get();
            this.text.set(s.substring(0, this.cursor - 1) + s.substring(this.cursor));
            --this.cursor;
            this.cursorTicks = 0;
            return true;
        }
        if (keyCode == 261 && ((String)this.text.get()).length() > this.cursor) {
            String s = (String)this.text.get();
            this.text.set(s.substring(0, this.cursor) + s.substring(this.cursor + 1));
            this.cursorTicks = 0;
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.text.set((String)this.text.get() + '\n');
            ++this.cursor;
            this.cursorTicks = 0;
            return true;
        }
        if (keyCode == 263 && ((String)this.text.get()).length() > 0) {
            --this.cursor;
            this.cursorTicks = 0;
            return true;
        }
        if (keyCode == 262 && ((String)this.text.get()).length() > this.cursor) {
            ++this.cursor;
            this.cursorTicks = 0;
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char key, int modifier) {
        if (super.func_231042_a_(key, modifier)) {
            return true;
        }
        if (key == '\u00a7' || SharedConstants.func_71566_a((char)key)) {
            String s = (String)this.text.get();
            this.text.set(s.substring(0, this.cursor) + key + s.substring(this.cursor));
            ++this.cursor;
            this.cursorTicks = 0;
            return true;
        }
        return false;
    }

    public String[] getLines() {
        String[] lines = ((String)this.text.get()).split("\n");
        return lines;
    }

    public List<String> getWrappedLines() {
        String[] lines = this.getLines();
        ArrayList<String> wrapped = new ArrayList<String>();
        for (String string : lines) {
        }
        return wrapped;
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        int y;
        int x;
        super.mainRender(matrix, mouseX, mouseY, p3, color);
        int i = 0;
        int chars = 0;
        for (String line : this.getWrappedLines()) {
            x = 15;
            y = 30 + i * 10;
            String renderLine = line.replace("\u00a7", "&");
            TextEditorScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)renderLine, (int)x, (int)y, (int)-1);
            if (this.cursorTicks < 10 && chars + renderLine.length() >= this.cursor) {
                if (this.cursor - chars > 0) {
                    x += this.field_230712_o_.func_78256_a(renderLine.substring(0, this.cursor - chars));
                }
                TextEditorScreen.func_238467_a_((MatrixStack)matrix, (int)x, (int)(++y), (int)(x + 1), (int)(y + 8), (int)-1);
            }
            chars += renderLine.length() + 1;
            ++i;
        }
        if (this.cursorTicks < 10) {
            char c;
            char[] charArray = ((String)this.text.get()).toCharArray();
            boolean newLine = false;
            for (int j = charArray.length - 1; j >= 0 && (c = charArray[j]) == '\n'; --j) {
                ++i;
                newLine = true;
            }
            if (newLine) {
                x = 15;
                y = 20 + i * 10;
                TextEditorScreen.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + 1), (int)(y + 8), (int)-1);
            }
        }
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.overlayRender(matrix, mouseX, mouseY, p3, color);
        if (this.preview == 1) {
            GuiUtil.addToolTip(matrix, (Screen)this, mouseX, mouseY, this.getLines());
        }
    }
}

