/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.tag.TagItemID;
import infinityitemeditor.data.tag.TagList;
import infinityitemeditor.screen.ParentItemScreen;
import infinityitemeditor.screen.widgets.ScrollableScissorWindow;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.util.ColorUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class PlaceDestroyScreen
extends ParentItemScreen {
    private TagList<TagItemID> canPlaceOnList;
    private ScrollableScissorWindow list;
    private ScrollableScissorWindow added;

    public PlaceDestroyScreen(Screen lastScreen, DataItem editing, String guiName, TagList<TagItemID> tagList) {
        super((ITextComponent)new TranslationTextComponent("gui." + guiName), lastScreen, editing);
        this.canPlaceOnList = tagList;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.renderItem = false;
        int yStart = 40;
        int yEnd = this.field_230709_l_ / 4 * 3 - yStart / 2 - 5;
        int containerWidth = this.field_230708_k_ / 7 * 3 - 10;
        int spacing = 10;
        int xStart = (this.field_230708_k_ - (containerWidth * 2 + spacing)) / 2;
        this.added = (ScrollableScissorWindow)this.func_230480_a_(new ScrollableScissorWindow(xStart, yStart, containerWidth, yEnd, (ITextComponent)new TranslationTextComponent("gui.placedestroy.applied")));
        this.list = (ScrollableScissorWindow)this.func_230480_a_(new ScrollableScissorWindow(xStart + spacing + containerWidth, yStart, containerWidth, yEnd, (ITextComponent)new TranslationTextComponent("gui.placedestroy.all")));
        block0: for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if (block.func_199767_j() == Items.field_190931_a) continue;
            for (TagItemID id : this.canPlaceOnList) {
                if (block.func_199767_j() != id.getItem()) continue;
                this.addCanPlaceOn(block, id, false);
                continue block0;
            }
            StyledButton button = this.addToAddedButton(block);
            this.list.getWidgets().add((Widget)button);
        }
    }

    private StyledButton addToAddedButton(Block block) {
        StyledButton button = new StyledButton(0, 0, 50, 20, (ITextComponent)block.func_235333_g_(), b -> {
            this.addCanPlaceOn(block, null, true);
            this.list.getWidgets().remove(b);
        });
        return button;
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        PlaceDestroyScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)this.added.func_230458_i_(), (int)this.added.field_230690_l_, (int)(this.added.field_230691_m_ - 10), (int)color.getInt());
        PlaceDestroyScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)this.list.func_230458_i_(), (int)this.list.field_230690_l_, (int)(this.list.field_230691_m_ - 10), (int)color.getInt());
        super.mainRender(matrix, mouseX, mouseY, p3, color);
    }

    private void addCanPlaceOn(Block block, TagItemID tagItemR, boolean shouldAdd) {
        TagItemID tagItem = new TagItemID((Item)Item.field_179220_a.get(block));
        if (tagItemR != null) {
            tagItem = tagItemR;
        }
        TagItemID finalTagItem = tagItem;
        StyledButton button = new StyledButton(0, 0, 50, 20, (ITextComponent)block.func_235333_g_(), t -> {
            this.added.getWidgets().remove(t);
            this.canPlaceOnList.remove(finalTagItem);
            this.list.getWidgets().add((Widget)this.addToAddedButton(block));
        });
        this.added.getWidgets().add((Widget)button);
        if (shouldAdd) {
            this.canPlaceOnList.add(finalTagItem);
        }
    }
}

