/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.InfinityItemEditor;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.screen.ParentScreen;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.util.ColorUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NBTExplorerScreen
extends ParentScreen {
    private long lastTime;
    private DataItem item;
    private File openFile = null;
    private Process process = null;

    public NBTExplorerScreen(Screen lastScreen, DataItem item) {
        super((ITextComponent)new TranslationTextComponent("gui.externalnbt"), lastScreen);
        this.item = item;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int buttons = 3;
        int slice = (this.field_230708_k_ - 110) / buttons;
        int i = 0;
        StyledButton open = (StyledButton)this.func_230480_a_((Widget)new StyledButton(15 + slice * i + slice / 2, this.field_230709_l_ / 2 + 10, 80, 20, "Open", button -> {
            try {
                this.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
        StyledButton reload = (StyledButton)this.func_230480_a_((Widget)new StyledButton(15 + slice * ++i + slice / 2, this.field_230709_l_ / 2 + 10, 80, 20, "Reload", button -> {
            if (this.openFile != null) {
                try {
                    this.item = new DataItem(ItemStack.func_199557_a((CompoundNBT)CompressedStreamTools.func_74797_a((File)this.openFile)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        StyledButton save = (StyledButton)this.func_230480_a_((Widget)new StyledButton(15 + slice * ++i + slice / 2, this.field_230709_l_ / 2 + 10, 80, 20, "Save", button -> {}));
        ++i;
    }

    public void open() throws IOException {
        if (this.openFile == null) {
            File nbtDir = this.getTempDir().toFile();
            nbtDir.mkdirs();
            this.openFile = File.createTempFile("external", ".dat", nbtDir);
            this.openFile.deleteOnExit();
            CompressedStreamTools.func_74795_b((CompoundNBT)this.item.getNBT(), (File)this.openFile);
        }
        if (this.process != null) {
            this.process.destroy();
        }
        this.process = new ProcessBuilder(this.getNBTExplorer(), "\"" + this.openFile.toPath() + "\"").start();
    }

    public Path getTempDir() {
        return InfinityItemEditor.DATAPATH.resolve("temp");
    }

    public String getNBTExplorer() {
        return "\"" + InfinityItemEditor.DATAPATH.resolve("nbtexplorer").resolve("NBTExplorer.exe") + "\"";
    }

    @Override
    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.backRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.mainRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.overlayRender(matrix, mouseX, mouseY, p3, color);
    }
}

