/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import infinityitemeditor.collections.ItemCollection;
import infinityitemeditor.collections.ItemCollections;
import infinityitemeditor.screen.ParentScreen;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import java.util.Date;
import java.util.Iterator;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ItemSpawnerScreen
extends ParentScreen {
    private static final Inventory TMP_INVENTORY = new Inventory(45);
    private static final int selectedTabIndex = ItemGroup.field_78030_b.getTabPage();
    private float currentScroll;
    private boolean isScrolling;
    private TextFieldWidget searchField;
    private static ItemCollection collection = ItemCollections.INSTANCE.getCollections().get(0);
    public final NonNullList<ItemStack> itemList = NonNullList.func_191196_a();
    private long lastTime = new Date().getTime();
    float animation = 0.0f;

    public ItemSpawnerScreen(Screen lastScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.itemspawner"), lastScreen);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            int i = 0;
            int x = 15;
            Iterator<ItemCollection> iterator = ItemCollections.INSTANCE.iterator();
            while (iterator.hasNext()) {
                int y = 30 + 20 * i;
                ItemCollection collection = iterator.next();
                String name = collection.getName();
                int width = this.field_230712_o_.func_78256_a(name);
                if (GuiUtil.isMouseInRegion(mouseX, mouseY, x, y, width + 20, 16)) {
                    ItemSpawnerScreen.collection = collection;
                    this.animation = 0.0f;
                    return true;
                }
                ++i;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        this.setTopLineWidth(this.field_230708_k_ - 30);
        super.backRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.mainRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.overlayRender(matrix, mouseX, mouseY, p3, color);
        this.itemList.clear();
        collection.fill(this.itemList);
        int i = 0;
        int widest = 0;
        int x = 10;
        int y = 0;
        for (ItemCollection collection : ItemCollections.INSTANCE) {
            boolean selected;
            String name = collection.getName();
            int width = this.field_230712_o_.func_78256_a(name);
            y = 30 + 20 * i;
            double itemYOffset = 0.0;
            boolean in = GuiUtil.isMouseInRegion(mouseX, mouseY, x, y, width + 20, 16);
            boolean bl = selected = ItemSpawnerScreen.collection == collection;
            if (selected) {
                long now = new Date().getTime();
                if (now - this.lastTime > 18L) {
                    this.animation += 0.1f;
                    this.lastTime = now;
                }
                itemYOffset = -Math.sin(this.animation) / 1.8;
                RenderSystem.translated((double)0.0, (double)itemYOffset, (double)0.0);
            }
            ItemStack stack = collection.getIcon();
            this.drawItemStack(stack, x, y, 0.0f, 0.0f, null);
            ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)name, (int)(x + 20), (int)(y + 5), (int)(in || selected ? StyleManager.getCurrentStyle().getFGColor(true, true).getInt() : color.getInt()));
            if (selected) {
                RenderSystem.translated((double)0.0, (double)(-itemYOffset), (double)0.0);
            }
            if (widest < width) {
                widest = width;
            }
            ++i;
        }
        ItemSpawnerScreen.func_238467_a_((MatrixStack)matrix, (int)(25 + (widest += 16)), (int)31, (int)(26 + widest), (int)(this.field_230709_l_ - 15), (int)color.getInt());
        int rightWidth = 150;
        ItemSpawnerScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ - 6 - rightWidth), (int)31, (int)(this.field_230708_k_ - 5 - rightWidth), (int)(this.field_230709_l_ - 15), (int)color.getInt());
        i = 0;
        int offsetY = 0;
        ItemSpawnerScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ - rightWidth + 5), (int)39, (int)(this.field_230708_k_ - 15), (int)40, (int)color.getInt());
        ItemSpawnerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Filters", (int)(this.field_230708_k_ - rightWidth / 2 - 5), (int)(28 + 20 * i), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Item ID", (int)(this.field_230708_k_ - rightWidth + 5), (int)((offsetY += 20) + 30 + 20 * i++), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Name", (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 30 + 20 * i++), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Tooltip", (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 30 + 20 * i++), (int)color.getInt());
        ItemSpawnerScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 45 + 20 * (i - 1)), (int)(this.field_230708_k_ - 15), (int)(offsetY + 46 + 20 * (i - 1)), (int)color.getInt());
        ItemSpawnerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Item Filters", (int)(this.field_230708_k_ - rightWidth / 2 - 5), (int)(offsetY + 50 + 20 * (i - 1)), (int)color.getInt());
        ItemSpawnerScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 62 + 20 * (i - 1)), (int)(this.field_230708_k_ - 15), (int)(offsetY + 63 + 20 * (i - 1)), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Enchantable", (int)(this.field_230708_k_ - rightWidth + 5), (int)((offsetY += 20) + 30 + 20 * i++), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Armor", (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 30 + 20 * i++), (int)color.getInt());
        ItemSpawnerScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 45 + 20 * (i - 1)), (int)(this.field_230708_k_ - 15), (int)(offsetY + 46 + 20 * (i - 1)), (int)color.getInt());
        ItemSpawnerScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Block Filters", (int)(this.field_230708_k_ - rightWidth / 2 - 5), (int)(offsetY + 50 + 20 * (i - 1)), (int)color.getInt());
        ItemSpawnerScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 62 + 20 * (i - 1)), (int)(this.field_230708_k_ - 15), (int)(offsetY + 63 + 20 * (i - 1)), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Block", (int)(this.field_230708_k_ - rightWidth + 5), (int)((offsetY += 20) + 30 + 20 * i++), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Light Level", (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 30 + 20 * i++), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Hardness", (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 30 + 20 * i++), (int)color.getInt());
        ItemSpawnerScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"TileEntity", (int)(this.field_230708_k_ - rightWidth + 5), (int)(offsetY + 30 + 20 * i++), (int)color.getInt());
        i = 0;
        int columns = (this.field_230708_k_ - 40 - widest - rightWidth) / 20;
        int rows = (this.field_230709_l_ - 50) / 20;
        for (ItemStack stack : this.itemList) {
            int column = i % columns;
            int row = i / columns;
            if (row >= rows) break;
            x = 30 + widest + 20 * column;
            y = 25 + 20 * row;
            this.drawItemStack(stack, x, y, 1.0f, 0.0f, null);
            ++i;
        }
    }
}

