/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import infinityitemeditor.json.CachedHead;
import infinityitemeditor.json.MinecraftHeads;
import infinityitemeditor.json.MinecraftHeadsCategory;
import infinityitemeditor.render.HeadRenderer;
import infinityitemeditor.screen.ParentScreen;
import infinityitemeditor.styles.Style;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import infinityitemeditor.util.InventoryUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class HeadCollectionScreen
extends ParentScreen {
    private final List<CachedHead> filteredHeads = new LinkedList<CachedHead>();
    private static MinecraftHeadsCategory selCat = MinecraftHeadsCategory.alphabet;
    private static int currentElement = 0;
    private static String filteredString = null;
    private static String searchString = "";
    private final int divideHeight = 20;
    private int maxInRow;
    private int amountInPage;

    public HeadCollectionScreen(Screen lastScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.headcollection"), lastScreen);
    }

    @Override
    public void func_231160_c_() {
        long startTime = System.nanoTime();
        super.func_231160_c_();
        this.maxInRow = (this.field_230708_k_ - 250) / 14;
        this.amountInPage = this.maxInRow * 10;
        filteredString = null;
        if (!searchString.equals(filteredString)) {
            this.filteredHeads.clear();
            Thread thread = new Thread(() -> {
                for (CachedHead head : MinecraftHeads.getHeads(selCat)) {
                    if (!head.getData().getName().contains(searchString)) continue;
                    this.filteredHeads.add(head);
                }
            });
            thread.start();
            currentElement = 0;
            filteredString = searchString;
        }
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        long endTime = System.nanoTime();
        long duration = (endTime - startTime) / 1000000L;
        System.out.println("Took " + duration + "ms to init head collection.");
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        int heightOffset = this.field_230709_l_ / 20;
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return false;
        }
        this.maxInRow = (this.field_230708_k_ - 250) / 14;
        this.amountInPage = this.maxInRow * 10;
        int letterSpace = 80;
        int space = (this.field_230708_k_ - this.maxInRow * 16 - letterSpace) / 2;
        int nextPageW = this.field_230712_o_.func_78256_a("-->");
        int topbar = 20;
        int currentPage = currentElement / this.amountInPage;
        int amountPages = (int)Math.ceil(this.filteredHeads.size() / this.amountInPage) + 1;
        int searchW = this.field_230712_o_.func_78256_a(searchString);
        if (searchString.length() > 0 && !searchString.equals(filteredString) && GuiUtil.isMouseInRegion((int)mouseX, (int)mouseY, this.field_230708_k_ / 2 - searchW / 2, heightOffset + 6, searchW, 8)) {
            this.func_231160_c_();
        } else {
            if (currentPage + 1 < amountPages && GuiUtil.isMouseInRegion((int)mouseX, (int)mouseY, space + letterSpace + this.maxInRow * 16 - 3 - nextPageW, heightOffset + topbar + 168, nextPageW, 8)) {
                currentElement = Math.min(this.filteredHeads.size() - 1, (currentPage + 1) * this.amountInPage);
                this.playClickSound();
                return false;
            }
            if (currentPage > 0 && GuiUtil.isMouseInRegion((int)mouseX, (int)mouseY, space + letterSpace + this.maxInRow * 16 - 25 - nextPageW * 2, heightOffset + topbar + 168, nextPageW, 8)) {
                currentElement = Math.max(0, (currentPage - 1) * this.amountInPage);
                this.playClickSound();
                return false;
            }
        }
        for (MinecraftHeadsCategory category : MinecraftHeadsCategory.values()) {
            int x = space + letterSpace / 2;
            int y = category.ordinal() * 15 + heightOffset + 9 + topbar;
            int sWH = this.field_230712_o_.func_78256_a(category.getName()) / 2;
            if (!(mouseX > (double)(x - sWH)) || !(mouseX < (double)(x + sWH)) || !(mouseY > (double)(y - 1)) || !(mouseY < (double)(y + 9))) continue;
            this.playClickSound();
            selCat = category;
            currentElement = 0;
            this.func_231160_c_();
            return false;
        }
        if (this.filteredHeads.size() > 0) {
            long startTime = System.nanoTime();
            for (int i = Math.min(this.filteredHeads.size() - 1, currentPage * this.amountInPage); i < Math.min(this.filteredHeads.size(), (currentPage + 1) * this.amountInPage); ++i) {
                int x = space + letterSpace + 16 * (i % this.maxInRow);
                int y = heightOffset + topbar + 16 * (i % this.amountInPage / this.maxInRow);
                Map map = this.field_230706_i_.func_152342_ad().func_152788_a(this.filteredHeads.get(i).getData().getGameProfile());
                if (map != null && map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    HeadRenderer.loadSkin((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), null, false);
                }
                if (!(mouseX > (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY > (double)y) || !(mouseY < (double)(y + 16))) continue;
                ItemStack is = this.filteredHeads.get(i).getItemStack();
                if (HeadCollectionScreen.func_231173_s_()) {
                    this.field_230706_i_.func_147114_u().func_147297_a((IPacket)new CCreativeInventoryActionPacket(-1, is));
                } else {
                    int slot = InventoryUtils.getEmptySlotsCount(this.field_230706_i_.field_71439_g.field_71071_by);
                    if (slot <= 0) {
                        this.field_230706_i_.func_147114_u().func_147297_a((IPacket)new CCreativeInventoryActionPacket(-1, is));
                    } else {
                        int emptySlot = InventoryUtils.getEmptySlot(this.field_230706_i_.field_71439_g.field_71071_by);
                        this.field_230706_i_.func_147114_u().func_147297_a((IPacket)new CCreativeInventoryActionPacket(emptySlot, is));
                        this.field_230706_i_.field_71439_g.func_184185_a(SoundEvents.field_187638_cR, 0.1f, 1.01f);
                    }
                }
                return true;
            }
            long endTime = System.nanoTime();
            long duration = (endTime - startTime) / 1000000L;
            System.out.println("Took " + duration + "ms to load head skins");
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    private void playClickSound() {
        this.field_230706_i_.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 0.2f, 1.01f);
    }

    @Override
    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        char c;
        String cha;
        if (super.func_231046_a_(key, scanCode, modifiers)) {
            return true;
        }
        if (key == 259) {
            if ((searchString = searchString.substring(0, Math.max(searchString.length() - 1, 0))).length() < 1 && !searchString.equals(filteredString)) {
                this.func_231160_c_();
            }
            return true;
        }
        if (!(key != 257 && key != 335 || searchString.equals(filteredString))) {
            this.func_231160_c_();
            return true;
        }
        if (key == 32) {
            searchString = searchString + " ";
        } else if (searchString.length() < 20 && (cha = String.valueOf(c = (char)key)).matches("[a-zA-Z0-9]")) {
            if (!HeadCollectionScreen.func_231173_s_()) {
                cha = cha.toLowerCase();
            }
            searchString = searchString + cha;
        }
        return false;
    }

    @Override
    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        this.maxInRow = (this.field_230708_k_ - 250) / 14;
        this.amountInPage = this.maxInRow * 10;
        int topbar = 20;
        int heightOffset = this.field_230709_l_ / 20;
        int letterSpace = 85;
        int space = (this.field_230708_k_ - (this.maxInRow * 16 + 3) - letterSpace) / 2;
        int currentPage = currentElement / this.amountInPage;
        int blandColor = GuiUtil.getColorFromRGB(255, 230, 230, 245);
        int amountPages = (int)Math.ceil(this.filteredHeads.size() / this.amountInPage) + 1;
        Style style = StyleManager.getCurrentStyle();
        int mainColor = color.getInt();
        HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)space, (int)(heightOffset + topbar), (int)(space + letterSpace + this.maxInRow * 16 + 3), (int)(heightOffset + topbar * 2 + 163), (int)GuiUtil.getColorFromRGB(110, 0, 0, 0));
        HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)(space + 2), (int)(heightOffset + topbar), (int)(space + letterSpace - 2), (int)(heightOffset + topbar + 161), (int)GuiUtil.getColorFromRGB(100, 50, 50, 50));
        HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)space, (int)heightOffset, (int)(space + letterSpace + this.maxInRow * 16 + 3), (int)(heightOffset + topbar), (int)mainColor);
        HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)space, (int)(heightOffset + topbar), (int)(space + 2), (int)(heightOffset + topbar + 161 + topbar), (int)mainColor);
        HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)(space + letterSpace + this.maxInRow * 16 + 1), (int)(heightOffset + topbar), (int)(space + letterSpace + this.maxInRow * 16 + 3), (int)(heightOffset + topbar + 161 + topbar), (int)mainColor);
        HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)(space + 2), (int)(heightOffset + topbar + 161), (int)(space + letterSpace + this.maxInRow * 16 + 1), (int)(heightOffset + topbar + 163), (int)mainColor);
        HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)space, (int)(heightOffset + topbar * 2 + 161), (int)(space + letterSpace + this.maxInRow * 16 + 3), (int)(heightOffset + topbar * 2 + 163), (int)mainColor);
        HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)(space + letterSpace), (int)(heightOffset + topbar), (int)(space + letterSpace - 2), (int)(heightOffset + topbar + 161), (int)mainColor);
        for (MinecraftHeadsCategory category : MinecraftHeadsCategory.values()) {
            int x = space + letterSpace / 2;
            int y = category.ordinal() * 15 + heightOffset + 9 + topbar;
            int sW = this.field_230712_o_.func_78256_a(category.getName());
            int sWH = sW / 2;
            HeadCollectionScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)("gui.headcollection.category." + category.getName()), (Object[])new Object[0]), (int)x, (int)y, (int)style.getFGColor(true, category == selCat || GuiUtil.isMouseInRegion(mouseX, mouseY, x - sWH, y - 1, sW, 10)).getInt());
        }
        HeadCollectionScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)(I18n.func_135052_a((String)"gui.headcollection", (Object[])new Object[0]) + " (" + this.filteredHeads.size() + ")"), (int)(space + 7), (int)(heightOffset + 6), (int)blandColor);
        HeadCollectionScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)(searchString.length() > 0 ? searchString : I18n.func_135052_a((String)"gui.headcollection.typesearch", (Object[])new Object[0])), (int)(this.field_230708_k_ / 2), (int)(heightOffset + 6), (int)blandColor);
        String pageString = I18n.func_135052_a((String)"gui.headcollection.currentpage", (Object[])new Object[]{currentPage + 1, amountPages});
        HeadCollectionScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)pageString, (int)(space + letterSpace + this.maxInRow * 16 - this.field_230712_o_.func_78256_a(pageString)), (int)(heightOffset + 6), (int)blandColor);
        String nextPage = "-->";
        int nextPageW = this.field_230712_o_.func_78256_a(nextPage);
        if (currentPage + 1 < amountPages) {
            boolean selectedN = GuiUtil.isMouseInRegion(mouseX, mouseY, space + letterSpace + this.maxInRow * 16 - 3 - nextPageW, heightOffset + topbar + 168, nextPageW, 8);
            HeadCollectionScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)nextPage, (int)(space + letterSpace + this.maxInRow * 16 - 3 - nextPageW), (int)(heightOffset + topbar + 168), (int)style.getFGColor(true, selectedN).getInt());
        }
        HeadCollectionScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)("" + (currentPage + 1)), (int)(space + letterSpace + this.maxInRow * 16 - 13 - nextPageW), (int)(heightOffset + topbar + 168), (int)blandColor);
        if (currentPage > 0) {
            String previousPage = "<--";
            boolean selectedP = GuiUtil.isMouseInRegion(mouseX, mouseY, space + letterSpace + this.maxInRow * 16 - 25 - nextPageW * 2, heightOffset + topbar + 168, nextPageW, 8);
            HeadCollectionScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)previousPage, (int)(space + letterSpace + this.maxInRow * 16 - 25 - nextPageW * 2), (int)(heightOffset + topbar + 168), (int)style.getFGColor(true, selectedP).getInt());
        }
        HeadCollectionScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.headcollection.credit", (Object[])new Object[0]), (int)(space + 7), (int)(heightOffset + topbar + 168), (int)blandColor);
        HeadCollectionScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)(I18n.func_135052_a((String)"gui.headcollection.freeslots", (Object[])new Object[0]) + ": " + InventoryUtils.getEmptySlotsCount(this.field_230706_i_.field_71439_g.field_71071_by)), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 45), (int)blandColor);
        HeadCollectionScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)(I18n.func_135052_a((String)"gui.headcollection.headsininventory", (Object[])new Object[0]) + ": " + InventoryUtils.countItem(this.field_230706_i_.field_71439_g.field_71071_by, Items.field_196184_dx)), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ - 35), (int)blandColor);
        ItemStack hovered = null;
        if (this.filteredHeads.size() > 0) {
            for (int i = Math.min(this.filteredHeads.size() - 1, currentPage * this.amountInPage); i < Math.min(this.filteredHeads.size(), (currentPage + 1) * this.amountInPage); ++i) {
                int x = space + letterSpace + 16 * (i % this.maxInRow);
                int y = heightOffset + topbar + 16 * (i % this.amountInPage / this.maxInRow);
                CachedHead cached = this.filteredHeads.get(i);
                ItemStack stack = cached.getItemStack();
                this.drawItemStack(stack, x, y, 1.0f, 0.0f, null);
                if (hovered != null || mouseX <= x || mouseX >= x + 16 || mouseY <= y || mouseY >= y + 16) continue;
                HeadCollectionScreen.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)GuiUtil.getColorFromRGB(150, 150, 150, 150));
                hovered = stack;
            }
        }
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)100.0f);
        int searchW = this.field_230712_o_.func_78256_a(searchString);
        if (hovered != null) {
            char section = "\u00a7r".charAt(0);
            GuiUtil.addToolTip(matrix, (Screen)this, mouseX, mouseY, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY, hovered.func_151000_E().getString(), section + "7" + I18n.func_135052_a((String)"gui.headcollection.clickhead", (Object[])new Object[0]), section + "7" + I18n.func_135052_a((String)"gui.headcollection.clickheadshift", (Object[])new Object[0]));
        } else if (!searchString.equals(filteredString) && GuiUtil.isMouseInRegion(mouseX, mouseY, this.field_230708_k_ / 2 - searchW / 2, 56, searchW, 8)) {
            GuiUtil.addToolTip(matrix, (Screen)this, mouseX, mouseY, I18n.func_135052_a((String)"gui.headcollection.clicksearch", (Object[])new Object[0]));
        } else {
            GuiUtil.addToolTip(matrix, (Screen)this, space + 2, heightOffset + topbar, letterSpace - 4, 161, mouseX, mouseY, I18n.func_135052_a((String)"gui.headcollection.changecategory", (Object[])new Object[0]));
        }
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-100.0f);
    }
}

