/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.base.DataColor;
import infinityitemeditor.screen.ParentItemScreen;
import infinityitemeditor.screen.widgets.HexField;
import infinityitemeditor.screen.widgets.SliderColorTag;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import infinityitemeditor.util.ItemUtils;
import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ColorScreen
extends ParentItemScreen {
    private final DataColor color;
    private boolean useAlpha;
    private SliderColorTag red;
    private SliderColorTag green;
    private SliderColorTag blue;
    private HexField hex;
    private boolean draggingSatBrightPicker = false;
    private boolean draggingHuePicker = false;

    public ColorScreen(Screen lastScreen, DataItem editing) {
        super((ITextComponent)new TranslationTextComponent("gui.color"), lastScreen, editing);
        this.setRenderItem(true, 2.0f);
        this.color = ItemUtils.getColorTag(editing);
        this.useAlpha = false;
    }

    public ColorScreen(Screen lastScreen, DataItem editing, DataColor color, boolean useAlpha) {
        super((ITextComponent)new TranslationTextComponent("gui.color"), lastScreen, editing);
        this.setRenderItem(true, 2.0f);
        this.color = color;
        this.useAlpha = useAlpha;
    }

    public ColorScreen(Screen lastScreen, DataItem editing, DataColor color, int defaultColor, boolean useAlpha) {
        this(lastScreen, editing, color, useAlpha);
        color.setDefColor(defaultColor);
        if (defaultColor != 0 && color.getInt() == 0) {
            color.setInt(defaultColor);
        }
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.hex = (HexField)this.func_230480_a_(new HexField(this.field_230712_o_, this.field_230708_k_ / 3 + (this.field_230712_o_.func_78256_a("#FFFFFF") + 8), this.field_230709_l_ / 3 + 40 + 10, 16, this.color));
        int yStart = this.field_230709_l_ / 2 - 50;
        int x = this.field_230708_k_ * 2 / 3 + 16;
        this.red = (SliderColorTag)this.func_230480_a_(new SliderColorTag(x, yStart, this.field_230708_k_ - 20 - x, 20, this.color, 0));
        this.green = (SliderColorTag)this.func_230480_a_(new SliderColorTag(x, yStart + 35, this.field_230708_k_ - 20 - x, 20, this.color, 1));
        this.blue = (SliderColorTag)this.func_230480_a_(new SliderColorTag(x, yStart + 70, this.field_230708_k_ - 20 - x, 20, this.color, 2));
    }

    @Override
    public void reset(Widget w) {
        this.color.setInt(this.color.getDefColor());
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.hex.updateCursorCounter();
    }

    public boolean setMouseColor(double mouseX, double mouseY) {
        int x = 25;
        int xEnd = this.field_230708_k_ / 3 - 20;
        int width = xEnd - x;
        int y = 60;
        int yEnd = y + width;
        if (this.draggingSatBrightPicker) {
            mouseX = MathHelper.func_151237_a((double)mouseX, (double)x, (double)xEnd);
            mouseY = MathHelper.func_151237_a((double)mouseY, (double)y, (double)yEnd);
            float sat = (float)((mouseX - (double)x) / (double)width);
            float bri = (float)(1.0 - (mouseY - 60.0) / (double)width);
            this.color.setHSB(this.color.getHue(), sat, bri);
            return true;
        }
        if (this.draggingHuePicker) {
            mouseX = MathHelper.func_151237_a((double)mouseX, (double)x, (double)xEnd);
            float hue = (float)((mouseX - (double)x) / (double)width);
            this.color.setHSB(hue, this.color.getSaturation(), this.color.getBrightness());
            return true;
        }
        return false;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            int x = 25;
            int xEnd = this.field_230708_k_ / 3 - 20;
            int width = xEnd - x;
            int y = 60;
            int yEnd = y + width;
            int height = yEnd - y;
            if (GuiUtil.isMouseInRegion(mouseX, mouseY, x, 60, width, height)) {
                this.draggingSatBrightPicker = true;
            } else if (GuiUtil.isMouseInRegion(mouseX, mouseY, x, yEnd + 3, width, 3)) {
                this.draggingHuePicker = true;
            }
            if (this.setMouseColor(mouseX, mouseY)) {
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.draggingSatBrightPicker = false;
            this.draggingHuePicker = false;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double onX, double onY) {
        if (this.setMouseColor(mouseX, mouseY)) {
            this.red.setColoredValue();
            this.green.setColoredValue();
            this.blue.setColoredValue();
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, onX, onY);
    }

    @Override
    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color guiColor) {
        super.backRender(matrix, mouseX, mouseY, p3, guiColor);
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ / 3), (int)20, (int)(this.field_230708_k_ / 3 + 1), (int)(this.field_230709_l_ / 5 * 4), (int)guiColor.getInt());
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ * 2 / 3), (int)20, (int)(this.field_230708_k_ * 2 / 3 + 1), (int)(this.field_230709_l_ / 5 * 4), (int)guiColor.getInt());
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)20, (int)40, (int)(this.field_230708_k_ / 3 - 15), (int)41, (int)guiColor.getInt());
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ * 2 / 3 + 16), (int)40, (int)(this.field_230708_k_ - 20), (int)41, (int)guiColor.getInt());
        int leftText = (5 + this.field_230708_k_ / 3) / 2;
        ColorScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"Color Pickers", (int)leftText, (int)30, (int)guiColor.getInt());
        ColorScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"HSB Picker", (int)leftText, (int)45, (int)guiColor.getInt());
        int rightText = this.field_230708_k_ * 2 / 3 + 16;
        ColorScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)"RGB Sliders", (int)(rightText + (this.field_230708_k_ - 20 - rightText) / 2), (int)30, (int)guiColor.getInt());
        int x = 25;
        int xEnd = this.field_230708_k_ / 3 - 20;
        int pickerWidth = xEnd - x;
        int y = 60;
        int yEnd = y + pickerWidth;
        float hue = this.color.getHue();
        GuiUtil.fillColorPicker(this, x, 60, xEnd, yEnd, hue);
        y = yEnd + 3;
        yEnd = y + 3;
        GuiUtil.fillHueSlider(this, x, y, xEnd, yEnd);
        int inverseColor = Color.HSBtoRGB((hue + 0.5f) % 1.0f, 1.0f, 1.0f);
        int colorX = (int)((float)x + this.color.getSaturation() * (float)pickerWidth);
        int colorY = (int)(60.0f + (1.0f - this.color.getBrightness()) * (float)pickerWidth);
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)(colorX - 1), (int)(colorY - 1), (int)colorX, (int)colorY, (int)inverseColor);
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)(colorX + 1), (int)(colorY - 1), (int)(colorX + 2), (int)colorY, (int)inverseColor);
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)(colorX - 1), (int)(colorY + 1), (int)colorX, (int)(colorY + 2), (int)inverseColor);
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)(colorX + 1), (int)(colorY + 1), (int)(colorX + 2), (int)(colorY + 2), (int)inverseColor);
        int hueX = (int)((float)x + this.color.getHue() * (float)pickerWidth);
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)hueX, (int)(y - 1), (int)(hueX + 1), (int)y, (int)inverseColor);
        ColorScreen.func_238467_a_((MatrixStack)matrix, (int)hueX, (int)yEnd, (int)(hueX + 1), (int)(yEnd + 1), (int)inverseColor);
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color guiColor) {
        super.mainRender(matrix, mouseX, mouseY, p3, guiColor);
        int halfWidth = this.field_230708_k_ / 2;
        int yStart = this.field_230709_l_ / 3 + 15;
        DataColor color = this.color;
        boolean i = false;
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color guiColor) {
        super.overlayRender(matrix, mouseX, mouseY, p3, guiColor);
        GuiUtil.addToolTip(matrix, (Screen)this, (Widget)this.resetButton, mouseX, mouseY, I18n.func_135052_a((String)"gui.color.reset", (Object[])new Object[0]));
    }

    public DataColor getColor() {
        return this.color;
    }

    public boolean isUseAlpha() {
        return this.useAlpha;
    }

    public void setUseAlpha(boolean useAlpha) {
        this.useAlpha = useAlpha;
    }
}

