/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.render;

import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Snooper;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class HeadRenderer
extends ItemStackTileEntityRenderer {
    public static final LazyValue<LoadingCache<GameProfile, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>>> skinLoader = new LazyValue(() -> (LoadingCache)ObfuscationReflectionHelper.getPrivateValue(SkinManager.class, (Object)Minecraft.func_71410_x().func_152342_ad(), (String)"insecureSkinCache"));
    private static final GenericHeadModel headModel = new HumanoidHeadModel();
    private static final ResourceLocation headSkin = DefaultPlayerSkin.func_177335_a();
    private static final Random rand = new Random();
    private static final FPSSnooper fpsSnooper = new FPSSnooper();

    private static RenderType getRenderType(GameProfile profile) {
        if (profile != null) {
            Minecraft mc = Minecraft.func_71410_x();
            LoadingCache loader = (LoadingCache)skinLoader.func_179281_c();
            Map map = (Map)loader.getIfPresent((Object)profile);
            RenderType res = null;
            res = map != null && map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.func_228644_e_((ResourceLocation)mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.func_228640_c_((ResourceLocation)DefaultPlayerSkin.func_177334_a((UUID)profile.getId()));
            return res;
        }
        return RenderType.func_228640_c_((ResourceLocation)headSkin);
    }

    public static void loadSkin(MinecraftProfileTexture profileTexture, SkinManager.ISkinAvailableCallback skinAvailableCallback, boolean requireSecure) {
        Runnable runnable = () -> {
            Minecraft mc = Minecraft.func_71410_x();
            mc.execute(() -> RenderSystem.recordRenderCall(() -> {
                long startTime = System.nanoTime();
                mc.func_152342_ad().func_152792_a(profileTexture, MinecraftProfileTexture.Type.SKIN);
                long endTime = System.nanoTime();
                long duration = endTime - startTime;
            }));
        };
        Util.func_215072_e().execute(runnable);
    }

    static class FPSSnooper
    extends Snooper {
        int fps = -1;
        long lastGet = Util.func_211177_b();

        public FPSSnooper() {
            super("client", (ISnooperInfo)Minecraft.func_71410_x(), Util.func_211177_b());
        }

        public int getFps() {
            long now = Util.func_211177_b();
            if (now - this.lastGet > 5000L) {
                Minecraft.func_71410_x().func_70000_a((Snooper)this);
                this.lastGet = now;
            }
            return this.fps;
        }

        public void func_152768_a(String statName, Object statValue) {
            if (statName.equals("fps")) {
                this.fps = (Integer)statValue;
            }
        }
    }
}

