/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.players;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import infinityitemeditor.InfinityItemEditor;
import infinityitemeditor.players.PlayerInfoResponse;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;

public class PlayerInfo {
    private static final Path PATH = InfinityItemEditor.DATAPATH.resolve("players");
    private static final HashMap<UUID, PlayerInfo> CACHE = new HashMap();
    private final String namePlate;

    private PlayerInfo(UUID uuid) throws JsonParseException, IOException {
        CACHE.put(uuid, this);
        PlayerInfoResponse resp = PlayerInfo.readPlayerInfo(uuid);
        this.namePlate = resp != null ? resp.getNameplate() : null;
    }

    public static PlayerInfo getByUUID(UUID uuid) {
        try {
            return CACHE.getOrDefault(uuid, new PlayerInfo(uuid));
        }
        catch (JsonParseException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    private static PlayerInfoResponse readPlayerInfo(UUID uuid) throws IOException, JsonParseException {
        File file = PATH.resolve(uuid.toString() + ".json").toFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FileReader reader = new FileReader(file);
        Gson gson = new Gson();
        PlayerInfoResponse response = (PlayerInfoResponse)gson.fromJson((Reader)reader, PlayerInfoResponse.class);
        ((Reader)reader).close();
        return response;
    }

    public String getNamePlate() {
        return this.namePlate;
    }
}

