/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import infinityitemeditor.json.CachedHead;
import infinityitemeditor.json.MinecraftHeadsCategory;
import infinityitemeditor.json.MinecraftHeadsResponse;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class MinecraftHeads {
    public static final String API_URL = "https://minecraft-heads.com/scripts/api.php?cat=";
    private static final EnumMap<MinecraftHeadsCategory, ArrayList<CachedHead>> CACHED_HEADS = new EnumMap(MinecraftHeadsCategory.class);

    public static ArrayList<CachedHead> getHeads(MinecraftHeadsCategory category) {
        ArrayList<CachedHead> list = CACHED_HEADS.get((Object)category);
        if (list == null && (list = MinecraftHeads.loadCategoryItemStack(category)) == null) {
            return new ArrayList<CachedHead>();
        }
        return list;
    }

    public static ArrayList<ItemStack> createItemStacks(MinecraftHeadsCategory category) {
        ArrayList<CachedHead> list = CACHED_HEADS.get((Object)category);
        if (list == null && (list = MinecraftHeads.loadCategoryItemStack(category)) == null) {
            return new ArrayList<ItemStack>();
        }
        long startTime = System.nanoTime();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (CachedHead head : list) {
            stacks.add(head.getItemStack());
        }
        long endTime = System.nanoTime();
        long duration = (endTime - startTime) / 1000000L;
        System.out.println("Took " + duration + "ms to generate head itemstacks.");
        return stacks;
    }

    public static boolean isLoaded(MinecraftHeadsCategory category) {
        return CACHED_HEADS.containsKey((Object)category);
    }

    @Nullable
    private static ArrayList<CachedHead> loadCategoryItemStack(MinecraftHeadsCategory category) {
        try {
            MinecraftHeadsResponse[] response = MinecraftHeads.readCategory(category);
            ArrayList<CachedHead> list = new ArrayList<CachedHead>(response.length);
            long startTime = System.nanoTime();
            for (MinecraftHeadsResponse element : response) {
                list.add(new CachedHead(element));
            }
            long endTime = System.nanoTime();
            long duration = (endTime - startTime) / 1000000L;
            System.out.println("Took " + duration + "ms to convert to CachedHead.");
            if (!list.isEmpty()) {
                CACHED_HEADS.put(category, list);
            }
            return list;
        }
        catch (JsonParseException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static MinecraftHeadsResponse[] readCategory(MinecraftHeadsCategory category) throws IOException, JsonParseException {
        long startTime = System.nanoTime();
        InputStreamReader reader = new InputStreamReader(category.getURL().openStream());
        Gson gson = new Gson();
        MinecraftHeadsResponse[] response = (MinecraftHeadsResponse[])gson.fromJson((Reader)reader, MinecraftHeadsResponse[].class);
        reader.close();
        long endTime = System.nanoTime();
        long duration = (endTime - startTime) / 1000000L;
        System.out.println("Took " + duration + "ms to download category.");
        return response;
    }
}

