/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag.entity;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.tag.TagItemList;
import infinityitemeditor.screen.container.EquipmentInventory;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class TagEntity<E extends Entity>
implements Data<E, CompoundNBT> {
    protected TagItemList armorItems;
    protected TagItemList handItems;

    public TagEntity(TagItemList armorItems, TagItemList handItems) {
        this.armorItems = armorItems;
        this.handItems = handItems;
    }

    public EquipmentInventory getInventory() {
        return new EquipmentInventory(this.armorItems, this.handItems);
    }

    @Override
    public boolean isDefault() {
        return this.handItems.isDefault() && this.armorItems.isDefault();
    }

    @Override
    public CompoundNBT getNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.armorItems.isDefault()) {
            nbt.func_218657_a("ArmorItems", (INBT)this.armorItems.getNBT());
        }
        if (!this.handItems.isDefault()) {
            nbt.func_218657_a("HandItems", (INBT)this.handItems.getNBT());
        }
        return nbt;
    }

    public TagItemList getArmorItems() {
        return this.armorItems;
    }

    public TagItemList getHandItems() {
        return this.handItems;
    }
}

