/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import com.mojang.authlib.GameProfile;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.DataUnserializedCompound;
import infinityitemeditor.data.NumberRangeInt;
import infinityitemeditor.data.base.DataBoolean;
import infinityitemeditor.data.base.DataColor;
import infinityitemeditor.data.base.DataInteger;
import infinityitemeditor.data.base.DataListString;
import infinityitemeditor.data.base.DataString;
import infinityitemeditor.data.tag.TagAttributeModifier;
import infinityitemeditor.data.tag.TagDamage;
import infinityitemeditor.data.tag.TagDisplay;
import infinityitemeditor.data.tag.TagEffect;
import infinityitemeditor.data.tag.TagEnchantment;
import infinityitemeditor.data.tag.TagExplosion;
import infinityitemeditor.data.tag.TagFirework;
import infinityitemeditor.data.tag.TagGameProfile;
import infinityitemeditor.data.tag.TagHideFlags;
import infinityitemeditor.data.tag.TagItemID;
import infinityitemeditor.data.tag.TagList;
import infinityitemeditor.data.tag.TagMapDecoration;
import infinityitemeditor.data.tag.block.TagBlockEntity;
import infinityitemeditor.data.tag.entity.TagEntityArmorStand;
import infinityitemeditor.data.version.NBTKeys;
import net.minecraft.nbt.CompoundNBT;
import org.apache.commons.lang3.StringUtils;

public class TagItemNBT
extends DataUnserializedCompound {
    private final DataItem item;
    private final TagDamage damage;
    private final DataBoolean unbreakable;
    private final TagList<TagItemID> canDestroy;
    private final TagDisplay display;
    private final TagHideFlags hideFlags;
    private final TagList<TagEnchantment> enchantments;
    private final TagList<TagEnchantment> storedEnchantments;
    private final DataInteger repairCost;
    private final TagList<TagAttributeModifier> attributes;
    private final TagList<TagEffect> potionEffects;
    private final DataString potion;
    private final DataColor potionColor;
    private final TagList<TagEffect> effects;
    private final TagList<TagItemID> canPlaceOn;
    private final TagBlockEntity blockEntityTag;
    private final DataBoolean resolved;
    private final NumberRangeInt generation;
    private final DataString author;
    private final DataString title;
    private final DataListString pages;
    private final TagList<TagItemID> chargedProjectiles;
    private final DataBoolean charged;
    private final TagExplosion explosion;
    private final TagFirework fireworks;
    private final TagGameProfile skullOwner;
    private final DataInteger mapNumber;
    private final TagList<TagMapDecoration> mapDecorations;
    private final TagEntityArmorStand armorStandTag;

    public TagItemNBT(DataItem item, CompoundNBT nbt) {
        super(nbt);
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        this.item = item;
        NBTKeys keys = NBTKeys.keys;
        this.damage = this.add(keys.tagDamage(), new TagDamage(item, nbt.func_74762_e(keys.tagDamage())));
        this.unbreakable = this.add(keys.tagUnbreakable(), new DataBoolean(nbt.func_74767_n(keys.tagUnbreakable())));
        this.canDestroy = this.add(keys.tagCanDestroy(), new TagList<TagItemID>(nbt.func_150295_c(keys.tagCanDestroy(), 8), TagItemID::new));
        this.display = this.add(keys.tagDisplay(), new TagDisplay(item, nbt.func_74775_l(keys.tagDisplay())));
        this.hideFlags = this.add(keys.tagHideFlags(), new TagHideFlags(nbt.func_74762_e(keys.tagHideFlags())));
        this.enchantments = this.add(keys.tagEnchantments(), new TagList<TagEnchantment>(nbt.func_150295_c(keys.tagEnchantments(), 10), TagEnchantment::new));
        this.storedEnchantments = this.add(keys.tagStoredEnchantments(), new TagList<TagEnchantment>(nbt.func_150295_c(keys.tagStoredEnchantments(), 10), TagEnchantment::new));
        this.repairCost = this.add(keys.tagRepairCost(), new DataInteger(nbt.func_74762_e(keys.tagRepairCost())));
        this.attributes = this.add(keys.tagAttributes(), new TagList<TagAttributeModifier>(nbt.func_150295_c(keys.tagAttributes(), 10), TagAttributeModifier::new));
        this.potionEffects = this.add(keys.tagCustomPotionEffects(), new TagList<TagEffect>(nbt.func_150295_c(keys.tagCustomPotionEffects(), 10), TagEffect::new));
        this.potion = this.add(keys.tagPotion(), new DataString(nbt.func_74779_i(keys.tagPotion())));
        this.potionColor = this.add(keys.tagCustomPotionColor(), new DataColor(nbt.func_74762_e(keys.tagCustomPotionColor())));
        this.effects = this.add(keys.tagEffects(), new TagList<TagEffect>(nbt.func_150295_c(keys.tagCustomPotionEffects(), 10), TagEffect::new));
        this.canPlaceOn = this.add(keys.tagCanPlaceOn(), new TagList<TagItemID>(nbt.func_150295_c(keys.tagCanPlaceOn(), 8), TagItemID::new));
        this.blockEntityTag = this.add(keys.tagBlockEntityTag(), new TagBlockEntity(nbt.func_74775_l(keys.tagBlockEntityTag())));
        this.resolved = this.add(keys.tagResolved(), new DataBoolean(nbt.func_74767_n(keys.tagResolved())));
        this.generation = this.add(keys.tagGeneration(), new NumberRangeInt(nbt.func_74762_e(keys.tagGeneration()), 0, 3));
        this.author = this.add(keys.tagAuthor(), new DataString(nbt.func_74779_i(keys.tagAuthor())));
        this.title = this.add(keys.tagTitle(), new DataString(nbt.func_74779_i(keys.tagTitle())));
        this.pages = this.add(keys.tagPages(), new DataListString(nbt.func_150295_c(keys.tagPages(), 8)));
        this.chargedProjectiles = this.add(keys.tagChargedProjectiles(), new TagList<TagItemID>(nbt.func_150295_c(keys.tagChargedProjectiles(), 8), TagItemID::new));
        this.charged = this.add(keys.tagCharged(), new DataBoolean(nbt.func_74767_n(keys.tagCharged())));
        this.explosion = this.add(keys.tagExplosion(), new TagExplosion(nbt.func_74775_l(keys.tagExplosion())));
        this.fireworks = this.add(keys.tagFireworks(), new TagFirework(nbt.func_74775_l(keys.tagFireworks())));
        this.skullOwner = nbt.func_150297_b(keys.tagSkullOwner(), 10) ? new TagGameProfile(nbt.func_74775_l(keys.tagSkullOwner())) : (nbt.func_150297_b(keys.tagSkullOwner(), 8) && !StringUtils.isBlank((CharSequence)nbt.func_74779_i(keys.tagSkullOwner())) ? new TagGameProfile(nbt.func_74779_i(keys.tagSkullOwner())) : new TagGameProfile((GameProfile)null));
        this.add(keys.tagSkullOwner(), this.skullOwner);
        this.mapNumber = this.add(keys.tagMapNumber(), new DataInteger(nbt.func_74762_e(keys.tagMapNumber())));
        this.mapDecorations = this.add(keys.tagMapDecorations(), new TagList<TagMapDecoration>(nbt.func_150295_c(keys.tagMapDecorations(), 10), TagMapDecoration::new));
        this.armorStandTag = this.add(keys.tagEntityTag(), new TagEntityArmorStand(nbt.func_74775_l(keys.tagEntityTag())));
    }

    @Override
    public TagItemNBT getData() {
        return this;
    }

    public DataItem getItem() {
        return this.item;
    }

    public TagDamage getDamage() {
        return this.damage;
    }

    public DataBoolean getUnbreakable() {
        return this.unbreakable;
    }

    public TagList<TagItemID> getCanDestroy() {
        return this.canDestroy;
    }

    public TagDisplay getDisplay() {
        return this.display;
    }

    public TagHideFlags getHideFlags() {
        return this.hideFlags;
    }

    public TagList<TagEnchantment> getEnchantments() {
        return this.enchantments;
    }

    public TagList<TagEnchantment> getStoredEnchantments() {
        return this.storedEnchantments;
    }

    public DataInteger getRepairCost() {
        return this.repairCost;
    }

    public TagList<TagAttributeModifier> getAttributes() {
        return this.attributes;
    }

    public TagList<TagEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public DataString getPotion() {
        return this.potion;
    }

    public DataColor getPotionColor() {
        return this.potionColor;
    }

    public TagList<TagEffect> getEffects() {
        return this.effects;
    }

    public TagList<TagItemID> getCanPlaceOn() {
        return this.canPlaceOn;
    }

    public TagBlockEntity getBlockEntityTag() {
        return this.blockEntityTag;
    }

    public DataBoolean getResolved() {
        return this.resolved;
    }

    public NumberRangeInt getGeneration() {
        return this.generation;
    }

    public DataString getAuthor() {
        return this.author;
    }

    public DataString getTitle() {
        return this.title;
    }

    public DataListString getPages() {
        return this.pages;
    }

    public TagList<TagItemID> getChargedProjectiles() {
        return this.chargedProjectiles;
    }

    public DataBoolean getCharged() {
        return this.charged;
    }

    public TagExplosion getExplosion() {
        return this.explosion;
    }

    public TagFirework getFireworks() {
        return this.fireworks;
    }

    public TagGameProfile getSkullOwner() {
        return this.skullOwner;
    }

    public DataInteger getMapNumber() {
        return this.mapNumber;
    }

    public TagList<TagMapDecoration> getMapDecorations() {
        return this.mapDecorations;
    }

    public TagEntityArmorStand getArmorStandTag() {
        return this.armorStandTag;
    }
}

