/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.base.SingularData;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TagItemList
extends SingularData<DataItem[], ListNBT> {
    public TagItemList(int size) {
        super(new DataItem[size]);
    }

    public TagItemList(ListNBT items, int size) {
        this(size);
        int i = 0;
        for (INBT nbt : items) {
            if (nbt instanceof CompoundNBT) {
                ((DataItem[])this.data)[i] = new DataItem((CompoundNBT)nbt);
            }
            ++i;
        }
    }

    public TagItemList(ListNBT items) {
        this(items, items.size());
    }

    @Override
    public boolean isDefault() {
        for (DataItem item : (DataItem[])this.data) {
            if (item == null || item.isDefault()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ListNBT getNBT() {
        ListNBT nbt = new ListNBT();
        int slot = 0;
        for (DataItem item : (DataItem[])this.data) {
            if (item == null) {
                item = new DataItem();
            }
            item.getSlot().set(slot++);
            nbt.add((Object)item.getNBT());
        }
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        StringTextComponent iformattabletextcomponent = new StringTextComponent("[");
        for (int i = 0; i < ((DataItem[])this.data).length; ++i) {
            IFormattableTextComponent iformattabletextcomponent1 = new StringTextComponent(((DataItem[])this.data)[i].getItem().getIDExcludingMC()).func_240699_a_(SYNTAX_HIGHLIGHTING_NUMBER);
            iformattabletextcomponent.func_240702_b_(" ").func_230529_a_((ITextComponent)iformattabletextcomponent1);
            if (i == ((DataItem[])this.data).length - 1) continue;
            iformattabletextcomponent.func_240702_b_(",");
        }
        iformattabletextcomponent.func_240702_b_("]");
        return iformattabletextcomponent;
    }

    public ListNBT getNBTEmptyDefaults() {
        ListNBT nbt = new ListNBT();
        int slot = 0;
        for (DataItem item : (DataItem[])this.data) {
            if (item == null || (Integer)item.getCount().get() == 0 || item.getItem().getItem() == Items.field_190931_a) {
                nbt.add((Object)new CompoundNBT());
            } else {
                item.getSlot().set(slot);
                nbt.add((Object)item.getNBT());
            }
            ++slot;
        }
        return nbt;
    }
}

