/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import infinityitemeditor.data.base.SingularData;
import infinityitemeditor.json.MinecraftHeadsResponse;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TagGameProfile
extends SingularData<GameProfile, CompoundNBT> {
    public TagGameProfile(String username) {
        this(new GameProfile(null, username));
    }

    public TagGameProfile(CompoundNBT nbt) {
        this(NBTUtil.func_152459_a((CompoundNBT)nbt));
    }

    public TagGameProfile(GameProfile profile) {
        super(profile);
    }

    public TagGameProfile(MinecraftProfilePropertiesResponse profile) {
        super(new GameProfile(profile.getId(), profile.getName()));
        ((GameProfile)this.data).getProperties().putAll((Multimap)profile.getProperties());
    }

    public TagGameProfile(MinecraftHeadsResponse profile) {
        super(new GameProfile(profile.getUUID(), profile.getName()));
        ((GameProfile)this.data).getProperties().putAll((Multimap)profile.getProperties());
    }

    @Override
    public void set(MinecraftHeadsResponse element) {
        this.data = element.getGameProfile();
    }

    @Override
    public boolean isDefault() {
        return this.data == null;
    }

    @Override
    public CompoundNBT getNBT() {
        return NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)((GameProfile)this.data));
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        StringTextComponent text = new StringTextComponent(((GameProfile)this.data).getName() == null ? "Player" : ((GameProfile)this.data).getName());
        if (((GameProfile)this.data).getId() != null) {
            text.func_240702_b_(((GameProfile)this.data).getId().toString());
        }
        return text;
    }
}

