/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.NumberRangeInt;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TagEnchantment
implements Data<TagEnchantment, CompoundNBT> {
    private Enchantment enchantment;
    private final NumberRangeInt level;

    public TagEnchantment(INBT nbt) {
        this(nbt instanceof CompoundNBT ? (CompoundNBT)nbt : new CompoundNBT());
    }

    public TagEnchantment(CompoundNBT nbt) {
        try {
            ResourceLocation rl = new ResourceLocation(nbt.func_74779_i("id"));
            this.enchantment = (Enchantment)GameRegistry.findRegistry(Enchantment.class).getValue(rl);
        }
        catch (ResourceLocationException e) {
            this.enchantment = Enchantment.func_185262_c((int)0);
        }
        this.level = new NumberRangeInt(nbt.func_74762_e("lvl"), 1, Integer.MAX_VALUE);
    }

    public TagEnchantment(Enchantment enchantment, int level) {
        this.enchantment = enchantment;
        this.level = new NumberRangeInt(level, 1, Integer.MAX_VALUE);
    }

    public TagEnchantment(Map.Entry<RegistryKey<Enchantment>, Enchantment> registryEntry) {
        this(registryEntry.getValue(), new NumberRangeInt(1, Integer.MAX_VALUE));
    }

    @Override
    public boolean isDefault() {
        return (Integer)this.level.get() == 0;
    }

    @Override
    public CompoundNBT getNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", this.enchantment.delegate.name().toString());
        nbt.func_74768_a("lvl", ((Integer)this.level.get()).intValue());
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        return this.enchantment.func_200305_d(((Integer)this.level.get()).intValue());
    }

    @Override
    public TagEnchantment getData() {
        return this;
    }

    public TagEnchantment(Enchantment enchantment, NumberRangeInt level) {
        this.enchantment = enchantment;
        this.level = level;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public void setEnchantment(Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    public NumberRangeInt getLevel() {
        return this.level;
    }
}

