/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.version.NBTKeys;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class TagBannerPattern
implements Data<Pair<BannerPattern, DyeColor>, CompoundNBT> {
    private BannerPattern pattern;
    private DyeColor color;

    public TagBannerPattern(INBT nbt) {
        this(nbt instanceof CompoundNBT ? (CompoundNBT)nbt : new CompoundNBT());
    }

    public TagBannerPattern(CompoundNBT nbt) {
        NBTKeys keys = NBTKeys.keys;
        this.color = DyeColor.func_196056_a((int)nbt.func_74762_e(keys.patternColor()));
        this.pattern = BannerPattern.func_190994_a((String)nbt.func_74779_i(keys.patternPattern()));
    }

    @Override
    public Pair<BannerPattern, DyeColor> getData() {
        return Pair.of((Object)this.pattern, (Object)this.color);
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public CompoundNBT getNBT() {
        NBTKeys keys = NBTKeys.keys;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(keys.patternColor(), this.color.func_196059_a());
        nbt.func_74778_a(keys.patternPattern(), this.pattern.func_190993_b());
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        return new StringTextComponent(this.color.func_176762_d()).func_240702_b_(" ").func_240702_b_(this.pattern.func_190997_a());
    }

    public TagBannerPattern(BannerPattern pattern, DyeColor color) {
        this.pattern = pattern;
        this.color = color;
    }

    public BannerPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(BannerPattern pattern) {
        this.pattern = pattern;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }
}

