/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.base;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.SingularData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DataMap
extends SingularData<Map<String, Data<?, ?>>, CompoundNBT> {
    public static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");

    public DataMap() {
        this(Maps.newHashMap());
    }

    public DataMap(Map<String, Data<?, ?>> map) {
        super(map);
    }

    public DataMap(CompoundNBT nbt) {
        this();
        if (nbt == null || nbt.isEmpty()) {
            return;
        }
        for (String key : nbt.func_150296_c()) {
            INBT value = nbt.func_74781_a(key);
            if (value == null) continue;
            this.put(key, Data.getDataFromNBT(value));
        }
    }

    @Nullable
    public Data<?, ?> getData(String key) {
        return (Data)((Map)this.data).get(key);
    }

    @Nonnull
    public Data<?, ?> getDataDefaulted(String key, @Nonnull Data<?, ?> defaultValue) {
        Data dat;
        if (!((Map)this.data).containsKey(key) && (dat = (Data)((Map)this.data).get(key)) != null) {
            return dat;
        }
        this.put(key, defaultValue);
        return defaultValue;
    }

    @Nonnull
    public <T extends Data<?, ?>> T getDataDefaultedForced(String key, @Nonnull T defaultValue) {
        Data existing;
        if (((Map)this.data).containsKey(key) && (existing = (Data)((Map)this.data).get(key)).getClass() == defaultValue.getClass()) {
            return (T)existing;
        }
        this.put(key, defaultValue);
        return defaultValue;
    }

    public void put(String key, Data<?, ?> value) {
        if (value != null) {
            ((Map)this.data).put(key, value);
        }
    }

    public void clear() {
        ((Map)this.data).clear();
    }

    @Override
    public boolean isDefault() {
        if (((Map)this.data).isEmpty()) {
            return true;
        }
        for (Map.Entry entry : ((Map)this.data).entrySet()) {
            if (((Data)entry.getValue()).isDefault()) continue;
            return false;
        }
        return true;
    }

    public CompoundNBT getNBTIncludeAll() {
        CompoundNBT nbt = new CompoundNBT();
        ((Map)this.data).forEach((key, value) -> {
            if (value instanceof DataMap) {
                nbt.func_218657_a(key, (INBT)((DataMap)value).getNBTIncludeAll());
            } else {
                nbt.func_218657_a(key, value.getNBT());
            }
        });
        return nbt;
    }

    @Override
    public CompoundNBT getNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ((Map)this.data).forEach((key, value) -> {
            if (!value.isDefault()) {
                nbt.func_218657_a(key, value.getNBT());
            }
        });
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        if (((Map)this.data).isEmpty()) {
            return new StringTextComponent("{}");
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("{");
        ArrayList collection = Lists.newArrayList(((Map)this.data).keySet());
        Collections.sort(collection);
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            IFormattableTextComponent iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(s)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(((Data)((Map)this.data).get(s)).getPrettyDisplay(space, indentation + 1));
            if (iterator.hasNext()) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)space, (int)indentation));
        }
        iformattabletextcomponent.func_240702_b_("}");
        return iformattabletextcomponent;
    }

    public static ITextComponent handleEscapePretty(String string) {
        if (SIMPLE_VALUE.matcher(string).matches()) {
            return new StringTextComponent(string).func_240699_a_(SYNTAX_HIGHLIGHTING_KEY);
        }
        String s = StringNBT.func_197654_a((String)string);
        String s1 = s.substring(0, 1);
        IFormattableTextComponent itextcomponent = new StringTextComponent(s.substring(1, s.length() - 1)).func_240699_a_(SYNTAX_HIGHLIGHTING_KEY);
        return new StringTextComponent(s1).func_230529_a_((ITextComponent)itextcomponent).func_240702_b_(s1);
    }
}

