/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.base;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.SingularData;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class DataList<E extends Data<?, ?>>
extends SingularData<List<E>, ListNBT>
implements Iterable<E> {
    public DataList() {
        this(Lists.newArrayList());
    }

    public DataList(ListNBT nbt) {
        this();
        nbt.forEach(this::add);
    }

    public DataList(List<E> list) {
        super(list);
    }

    public void add(E value) {
        ((List)this.data).add(value);
    }

    public abstract <T extends INBT> void add(T var1);

    public void remove(E value) {
        ((List)this.data).remove(value);
    }

    public void remove(int index) {
        ((List)this.data).remove(index);
    }

    public void clear() {
        ((List)this.data).clear();
    }

    @Override
    public boolean isDefault() {
        return ((List)this.data).isEmpty();
    }

    @Override
    public ListNBT getNBT() {
        ListNBT nbt = new ListNBT();
        ((List)this.data).forEach(dat -> {
            if (!dat.isDefault()) {
                nbt.add(dat.getNBT());
            }
        });
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        if (((List)this.data).isEmpty()) {
            return new StringTextComponent("[]");
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("[");
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        String s = String.valueOf(',');
        for (int i = 0; i < ((List)this.data).size(); ++i) {
            StringTextComponent iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1)));
            iformattabletextcomponent1.func_230529_a_(((Data)((List)this.data).get(i)).getPrettyDisplay(space, indentation + 1));
            if (i != ((List)this.data).size() - 1) {
                iformattabletextcomponent1.func_240702_b_(s).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)space, (int)indentation));
        }
        iformattabletextcomponent.func_240702_b_("]");
        return iformattabletextcomponent;
    }

    @Override
    public ListIterator<E> iterator() {
        return ((List)this.data).listIterator();
    }
}

