/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.base;

import infinityitemeditor.data.base.SingularData;
import infinityitemeditor.screen.widgets.StyledBitToggle;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.IntNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DataBitField
extends SingularData<boolean[], IntNBT>
implements Button.IPressable {
    private final boolean keepSize;

    public DataBitField(boolean keepSize, boolean ... data) {
        super(data);
        this.keepSize = keepSize;
    }

    public DataBitField(int size, IntNBT data) {
        this(size, data.func_150287_d());
    }

    public DataBitField(int size, int data) {
        super(new boolean[size]);
        this.keepSize = true;
        this.setInt(data);
    }

    @Override
    public void set(boolean[] value) {
        if (this.keepSize && value.length != ((boolean[])this.data).length) {
            for (int i = 0; i < value.length && i < ((boolean[])this.data).length; ++i) {
                ((boolean[])this.data)[i] = value[i];
            }
        } else {
            super.set(value);
        }
    }

    @Override
    public boolean isDefault() {
        return this.getInt() == 0;
    }

    public int getInt() {
        return DataBitField.booleanArrayToInt((boolean[])this.data);
    }

    public void setInt(int value) {
        for (int i = 0; i < ((boolean[])this.data).length; ++i) {
            ((boolean[])this.data)[i] = (value & 1 << i) != 0;
        }
    }

    public static int booleanArrayToInt(boolean[] array) {
        int result = 0;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            result += 1 << i;
        }
        return result;
    }

    @Override
    public IntNBT getNBT() {
        return IntNBT.func_229692_a_((int)this.getInt());
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        IFormattableTextComponent text = new StringTextComponent("0b").func_240699_a_(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        for (int i = 0; i < ((boolean[])this.data).length; ++i) {
            text.func_230529_a_((ITextComponent)new StringTextComponent(((boolean[])this.data)[i] ? "1" : "0").func_240699_a_(SYNTAX_HIGHLIGHTING_NUMBER));
        }
        return text;
    }

    public void onPress(Button button) {
        if (button instanceof StyledBitToggle) {
            StyledBitToggle but = (StyledBitToggle)button;
            ((boolean[])this.data)[but.index] = !((boolean[])this.data)[but.index];
            but.updateMessage(((boolean[])this.data)[but.index]);
        }
    }
}

