/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data;

import com.google.common.base.Strings;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import infinityitemeditor.data.Data;
import infinityitemeditor.data.NumberRangeInt;
import infinityitemeditor.data.base.DataMap;
import infinityitemeditor.data.tag.TagDamage;
import infinityitemeditor.data.tag.TagDisplayName;
import infinityitemeditor.data.tag.TagItemID;
import infinityitemeditor.data.tag.TagItemNBT;
import infinityitemeditor.data.version.NBTKeys;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SkullItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DataItem
implements Data<ItemStack, CompoundNBT> {
    private final TagItemID item;
    private final NumberRangeInt count;
    private final NumberRangeInt slot;
    private final TagItemNBT tag;

    public DataItem(TagItemID item, NumberRangeInt count, TagItemNBT tag, NumberRangeInt slot) {
        this.item = item;
        this.count = count;
        this.slot = slot;
        this.tag = tag;
    }

    public DataItem() {
        this(ItemStack.field_190927_a);
    }

    public DataItem(CompoundNBT nbt) {
        this(ItemStack.func_199557_a((CompoundNBT)nbt));
    }

    public DataItem(IItemProvider item) {
        this(new ItemStack(item));
    }

    public DataItem(ItemStack stack) {
        this(stack, 0);
    }

    public DataItem(Item item, String nbtString) throws CommandSyntaxException {
        this(item, 1, JsonToNBT.func_180713_a((String)nbtString), 0);
    }

    public DataItem(ItemStack stack, int slot) {
        this(stack.func_77973_b(), stack.func_190916_E(), stack.func_77978_p(), slot);
    }

    public DataItem(Item item, int count, CompoundNBT tag, int slot) {
        this.item = new TagItemID(item);
        this.count = new NumberRangeInt(count, 1, 64);
        this.slot = new NumberRangeInt(slot, 0, 45);
        this.tag = new TagItemNBT(this, tag);
    }

    public DataItem(Item item, int count, TileEntity te, int slot) {
        this(item, count, DataItem.getTETag(item, te), slot);
    }

    private static CompoundNBT getTETag(Item item, TileEntity te) {
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT teTag = te.func_189515_b(new CompoundNBT());
        if (item instanceof SkullItem && teTag.func_74764_b("Owner")) {
            CompoundNBT compoundnbt2 = teTag.func_74775_l("Owner");
            nbt.func_218657_a("SkullOwner", (INBT)compoundnbt2);
        } else {
            nbt.func_218657_a("BlockEntityTag", (INBT)teTag);
        }
        return nbt;
    }

    @Override
    public ItemStack getData() {
        return this.getItemStack();
    }

    public ItemStack getItemStack() {
        return ItemStack.func_199557_a((CompoundNBT)this.getNBT());
    }

    public ItemStack getItemStackFull() {
        return ItemStack.func_199557_a((CompoundNBT)this.getNBT());
    }

    public TagDisplayName getDisplayNameTag() {
        return this.getTag().getDisplay().getName();
    }

    public void clearCustomName() {
        this.getDisplayNameTag().reset();
    }

    public TagDamage getDamageTag() {
        return this.getTag().getDamage();
    }

    public DataItem split(int count) {
        int i = Math.min(count, (Integer)this.count.get());
        DataItem item = new DataItem(this.getNBT());
        item.count.set(i);
        this.count.set((Integer)this.count.get() - count);
        return item;
    }

    @Override
    public CompoundNBT getNBT() {
        NBTKeys keys = NBTKeys.keys;
        CompoundNBT nbt = new CompoundNBT();
        if (!this.getSlot().isDefault()) {
            nbt.func_218657_a(keys.stackSlot(), (INBT)this.getSlot().getNBT());
        }
        nbt.func_218657_a(keys.stackID(), (INBT)this.getItem().getNBT());
        nbt.func_218657_a(keys.stackCount(), (INBT)this.getCount().getNBT());
        if (!this.getTag().isDefault()) {
            nbt.func_218657_a(keys.stackTag(), (INBT)this.getTag().getNBT());
        }
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        IFormattableTextComponent iformattabletextcomponent1;
        boolean showTag;
        StringTextComponent iformattabletextcomponent = new StringTextComponent("{");
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        NBTKeys keys = NBTKeys.keys;
        String count = keys.stackCount();
        String slot = keys.stackSlot();
        String id = keys.stackID();
        String tag = keys.stackTag();
        boolean showCount = !this.getCount().isDefault();
        boolean showSlot = !this.getSlot().isDefault();
        boolean showId = !this.getItem().isDefault();
        boolean bl = showTag = !this.getTag().isDefault();
        if (showCount) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(count)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.count.getPrettyDisplay(space, indentation + 1));
            if (showSlot || showId || showTag) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showSlot) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(slot)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.slot.getPrettyDisplay(space, indentation + 1));
            if (showId || showTag) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showId) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(id)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.item.getPrettyDisplay(space, indentation + 1));
            if (showTag) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showTag) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(tag)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.tag.getPrettyDisplay(space, indentation + 1));
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)space, (int)indentation));
        }
        iformattabletextcomponent.func_240702_b_("}");
        return iformattabletextcomponent;
    }

    @Override
    public boolean isDefault() {
        return this.getItemStack().func_190926_b();
    }

    public DataItem copy() {
        return new DataItem(this.getNBT());
    }

    public TagItemID getItem() {
        return this.item;
    }

    public NumberRangeInt getCount() {
        return this.count;
    }

    public NumberRangeInt getSlot() {
        return this.slot;
    }

    public TagItemNBT getTag() {
        return this.tag;
    }
}

