/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data;

import infinityitemeditor.data.base.DataByte;
import infinityitemeditor.data.base.DataByteArray;
import infinityitemeditor.data.base.DataDouble;
import infinityitemeditor.data.base.DataFloat;
import infinityitemeditor.data.base.DataInteger;
import infinityitemeditor.data.base.DataIntegerArray;
import infinityitemeditor.data.base.DataListUncontrolled;
import infinityitemeditor.data.base.DataLong;
import infinityitemeditor.data.base.DataLongArray;
import infinityitemeditor.data.base.DataMap;
import infinityitemeditor.data.base.DataShort;
import infinityitemeditor.data.base.DataString;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public interface Data<E, T extends INBT> {
    public static final TextFormatting SYNTAX_HIGHLIGHTING_KEY = TextFormatting.AQUA;
    public static final TextFormatting SYNTAX_HIGHLIGHTING_STRING = TextFormatting.GREEN;
    public static final TextFormatting SYNTAX_HIGHLIGHTING_NUMBER = TextFormatting.GOLD;
    public static final TextFormatting SYNTAX_HIGHLIGHTING_NUMBER_TYPE = TextFormatting.RED;

    public E getData();

    public boolean isDefault();

    public T getNBT();

    public static <T> T convertInstanceOfObject(Object o, Class<T> clazz) {
        try {
            return clazz.cast(o);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Nullable
    public static Data<?, ?> getDataFromNBT(INBT nbt) {
        switch (nbt.func_74732_a()) {
            case 1: {
                return new DataByte((ByteNBT)nbt);
            }
            case 7: {
                return new DataByteArray((ByteArrayNBT)nbt);
            }
            case 10: {
                return new DataMap((CompoundNBT)nbt);
            }
            case 6: {
                return new DataDouble((DoubleNBT)nbt);
            }
            case 5: {
                return new DataFloat((FloatNBT)nbt);
            }
            case 3: {
                return new DataInteger((IntNBT)nbt);
            }
            case 11: {
                return new DataIntegerArray((IntArrayNBT)nbt);
            }
            case 9: {
                return new DataListUncontrolled((ListNBT)nbt);
            }
            case 4: {
                return new DataLong((LongNBT)nbt);
            }
            case 12: {
                return new DataLongArray((LongArrayNBT)nbt);
            }
            case 2: {
                return new DataShort((ShortNBT)nbt);
            }
            case 8: {
                return new DataString((StringNBT)nbt);
            }
        }
        return null;
    }

    public static boolean isNumber(INBT nbt) {
        byte id = nbt.func_74732_a();
        return id == 99 || 1 <= id && id <= 6;
    }

    default public ITextComponent getPrettyDisplay(String space, int indentantion) {
        return this.getNBT().func_199850_a(space, indentantion);
    }
}

