/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor;

import infinityitemeditor.config.Config;
import infinityitemeditor.events.EntityHandler;
import infinityitemeditor.events.KeyInputHandler;
import infinityitemeditor.events.PlayerNameplateHandler;
import infinityitemeditor.events.ScreenHandler;
import infinityitemeditor.events.TextureStitchHandler;
import infinityitemeditor.events.TooltipHandler;
import infinityitemeditor.render.ArmorStandRendering;
import infinityitemeditor.render.HeadRenderer;
import infinityitemeditor.render.ShieldRenderer;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.tab.CreativeTabs;
import infinityitemeditor.util.ReflectionUtils;
import java.nio.file.Path;
import net.minecraft.item.ArmorStandItem;
import net.minecraft.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="infinityitemeditor")
public class InfinityItemEditor {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "infinityitemeditor";
    public static final String NAME = "Infinity Item Editor";
    public static boolean BARRIER_VISIBLE = false;
    public static final boolean DEBUG = false;
    public static Path DATAPATH = FMLPaths.GAMEDIR.get().resolve("infinityitemeditor".concat("-data"));

    public InfinityItemEditor() {
        ModLoadingContext context = ModLoadingContext.get();
        LOGGER.info("Registering config");
        context.registerConfig(ModConfig.Type.CLIENT, Config.CLIENT);
        Config.loadConfig(Config.CLIENT, FMLPaths.CONFIGDIR.get().resolve(MODID.concat(".toml")));
        StyleManager.loadConfig();
        KeyInputHandler.init();
        CreativeTabs.init();
        LOGGER.info("Registering events");
        MinecraftForge.EVENT_BUS.register((Object)new ScreenHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerNameplateHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EntityHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new TextureStitchHandler());
        if (((Boolean)Config.SPECTRUM_SHIELD_ENABLED.get()).booleanValue()) {
            ReflectionUtils.setTeisr(Items.field_185159_cQ, () -> ShieldRenderer::new);
        }
        ReflectionUtils.setTeisr(Items.field_196184_dx, () -> HeadRenderer::new);
        if (Items.field_179565_cj instanceof ArmorStandItem) {
            ArmorStandRendering.addPropertyOverrides((ArmorStandItem)Items.field_179565_cj);
        }
    }
}

