/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons.block.custom.emergencybutton;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.larsmans.infinitybuttons.InfinityButtonsInit;
import net.larsmans.infinitybuttons.InfinityButtonsUtil;
import net.larsmans.infinitybuttons.advancement.InfinityButtonsTriggers;
import net.larsmans.infinitybuttons.block.custom.emergencybutton.EmergencyButton;
import net.larsmans.infinitybuttons.block.custom.emergencybutton.SEBStateEnum;
import net.larsmans.infinitybuttons.config.AlarmEnum;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4140;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

public class SafeEmergencyButton
extends class_2341 {
    public static final class_2754<SEBStateEnum> STATE = class_2754.method_11850((String)"state", SEBStateEnum.class);
    private static final class_265 STONE_DOWN = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final class_265 STONE_UP = class_2248.method_9541((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 STONE_NORTH = class_2248.method_9541((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)13.0, (double)16.0);
    private static final class_265 STONE_EAST = class_2248.method_9541((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)13.0);
    private static final class_265 STONE_SOUTH = class_2248.method_9541((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0);
    private static final class_265 STONE_WEST = class_2248.method_9541((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    private static final class_265 FLOOR_CLOSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (class_265)STONE_DOWN);
    private static final class_265 FLOOR_OPEN_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (class_265)STONE_DOWN);
    private static final class_265 FLOOR_PRESSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (class_265)STONE_DOWN);
    private static final class_265 CEILING_CLOSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0), (class_265)STONE_UP);
    private static final class_265 CEILING_OPEN_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (class_265)STONE_UP);
    private static final class_265 CEILING_PRESSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (class_265)STONE_UP);
    private static final class_265 NORTH_CLOSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)15.0), (class_265)STONE_NORTH);
    private static final class_265 NORTH_OPEN_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)15.0), (class_265)STONE_NORTH);
    private static final class_265 NORTH_PRESSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)15.0), (class_265)STONE_NORTH);
    private static final class_265 EAST_CLOSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)1.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0), (class_265)STONE_EAST);
    private static final class_265 EAST_OPEN_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)1.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0), (class_265)STONE_EAST);
    private static final class_265 EAST_PRESSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)1.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), (class_265)STONE_EAST);
    private static final class_265 SOUTH_CLOSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0, (double)8.0), (class_265)STONE_SOUTH);
    private static final class_265 SOUTH_OPEN_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)5.0), (class_265)STONE_SOUTH);
    private static final class_265 SOUTH_PRESSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)3.0), (class_265)STONE_SOUTH);
    private static final class_265 WEST_CLOSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)8.0, (double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0), (class_265)STONE_WEST);
    private static final class_265 WEST_OPEN_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)11.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), (class_265)STONE_WEST);
    private static final class_265 WEST_PRESSED_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)13.0, (double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0), (class_265)STONE_WEST);

    public SafeEmergencyButton(FabricBlockSettings settings) {
        super((class_4970.class_2251)settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657(STATE, (Comparable)((Object)SEBStateEnum.CLOSED))).method_11657((class_2769)field_11007, (Comparable)class_2738.field_12475));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{STATE, field_11177, field_11007});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        block0 : switch ((class_2738)state.method_11654((class_2769)field_11007)) {
            case field_12475: {
                switch ((SEBStateEnum)((Object)state.method_11654(STATE))) {
                    case CLOSED: {
                        return FLOOR_CLOSED_SHAPE;
                    }
                    case OPEN: {
                        return FLOOR_OPEN_SHAPE;
                    }
                    case PRESSED: {
                        return FLOOR_PRESSED_SHAPE;
                    }
                }
                break;
            }
            case field_12473: {
                switch ((SEBStateEnum)((Object)state.method_11654(STATE))) {
                    case CLOSED: {
                        return CEILING_CLOSED_SHAPE;
                    }
                    case OPEN: {
                        return CEILING_OPEN_SHAPE;
                    }
                    case PRESSED: {
                        return CEILING_PRESSED_SHAPE;
                    }
                }
                break;
            }
            case field_12471: {
                switch (direction) {
                    case field_11043: {
                        switch ((SEBStateEnum)((Object)state.method_11654(STATE))) {
                            case CLOSED: {
                                return NORTH_CLOSED_SHAPE;
                            }
                            case OPEN: {
                                return NORTH_OPEN_SHAPE;
                            }
                            case PRESSED: {
                                return NORTH_PRESSED_SHAPE;
                            }
                        }
                        break block0;
                    }
                    case field_11034: {
                        switch ((SEBStateEnum)((Object)state.method_11654(STATE))) {
                            case CLOSED: {
                                return EAST_CLOSED_SHAPE;
                            }
                            case OPEN: {
                                return EAST_OPEN_SHAPE;
                            }
                            case PRESSED: {
                                return EAST_PRESSED_SHAPE;
                            }
                        }
                        break block0;
                    }
                    case field_11035: {
                        switch ((SEBStateEnum)((Object)state.method_11654(STATE))) {
                            case CLOSED: {
                                return SOUTH_CLOSED_SHAPE;
                            }
                            case OPEN: {
                                return SOUTH_OPEN_SHAPE;
                            }
                            case PRESSED: {
                                return SOUTH_PRESSED_SHAPE;
                            }
                        }
                        break block0;
                    }
                    case field_11039: {
                        switch ((SEBStateEnum)((Object)state.method_11654(STATE))) {
                            case CLOSED: {
                                return WEST_CLOSED_SHAPE;
                            }
                            case OPEN: {
                                return WEST_OPEN_SHAPE;
                            }
                            case PRESSED: {
                                return WEST_PRESSED_SHAPE;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1934 gameMode = class_1934.field_28045;
        if (world.field_9236) {
            class_634 connection = class_310.method_1551().method_1562();
            assert (connection != null);
            gameMode = Objects.requireNonNull(connection.method_2871(player.method_7334().getId())).method_2958();
        } else if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            gameMode = serverPlayer.field_13974.method_14257();
        }
        if (gameMode == class_1934.field_9219) {
            return class_1269.field_5814;
        }
        switch ((SEBStateEnum)((Object)state.method_11654(STATE))) {
            case PRESSED: {
                return class_1269.field_21466;
            }
            case OPEN: {
                if (player.method_5715()) {
                    this.closeCase(state, world, pos);
                    this.playToggleSound(player, (class_1936)world, pos, false);
                    break;
                }
                this.powerOn(state, world, pos);
                this.playClickSound(player, (class_1936)world, pos, true);
                EmergencyButton.emergencySound(world, pos);
                if (player instanceof class_3222) {
                    InfinityButtonsTriggers.EMERGENCY_TRIGGER.trigger((class_3222)player);
                }
                if (!world.field_9236 && InfinityButtonsInit.CONFIG.alarmVillagerPanic()) {
                    List<class_1309> villagers = new ArrayList();
                    if (InfinityButtonsInit.CONFIG.alarmSoundType() == AlarmEnum.GLOBAL) {
                        villagers = new ArrayList();
                        List villagersDup = world.method_8390(class_1309.class, new class_238(pos).method_1014(512.0), entity -> entity.method_5864() == class_1299.field_6077);
                        for (class_1657 player1 : world.method_18456()) {
                            villagersDup.addAll(world.method_8390(class_1309.class, new class_238(player1.method_24515()).method_1014(512.0), entity -> entity.method_5864() == class_1299.field_6077));
                        }
                        for (class_1309 villager : villagersDup) {
                            if (villagers.contains(villager)) continue;
                            villagers.add(villager);
                        }
                    }
                    if (InfinityButtonsInit.CONFIG.alarmSoundType() == AlarmEnum.RANGE) {
                        villagers = world.method_8390(class_1309.class, new class_238(pos).method_1014((double)InfinityButtonsInit.CONFIG.alarmSoundRange()), entity -> entity.method_5864() == class_1299.field_6077);
                    }
                    for (class_1309 villager : villagers) {
                        if (!(villager instanceof class_1646)) continue;
                        class_1646 villagerEntity = (class_1646)villager;
                        villagerEntity.method_18868().method_18878(class_4140.field_19009, (Object)world.method_8510());
                    }
                }
                world.method_33596((class_1297)player, class_5712.field_28174, pos);
                break;
            }
            case CLOSED: {
                if (player.method_5715()) {
                    this.openCase(state, world, pos);
                    this.playToggleSound(player, (class_1936)world, pos, true);
                    break;
                }
                player.method_7353((class_2561)InfinityButtonsUtil.SAFE_EMERGENCY_BUTTON_ACTIONBAR_TEXT, true);
                return class_1269.field_21466;
            }
        }
        return class_1269.method_29236((boolean)world.field_9236);
    }

    public void openCase(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8652(pos, (class_2680)state.method_11657(STATE, (Comparable)((Object)SEBStateEnum.OPEN)), 3);
        this.updateNeighbors(state, world, pos);
    }

    public void closeCase(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8652(pos, (class_2680)state.method_11657(STATE, (Comparable)((Object)SEBStateEnum.CLOSED)), 3);
        this.updateNeighbors(state, world, pos);
    }

    public void powerOn(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8652(pos, (class_2680)state.method_11657(STATE, (Comparable)((Object)SEBStateEnum.PRESSED)), 3);
        this.updateNeighbors(state, world, pos);
        world.method_39279(pos, (class_2248)this, 10);
    }

    protected void playClickSound(@Nullable class_1657 player, class_1936 world, class_2338 pos, boolean pressed) {
        world.method_8396((class_1657)(pressed ? player : null), pos, class_3417.field_21872, class_3419.field_15245, 1.0f, pressed ? 0.6f : 0.5f);
    }

    protected void playToggleSound(@Nullable class_1657 player, class_1936 world, class_2338 pos, boolean pressed) {
        world.method_8396((class_1657)(pressed ? player : null), pos, pressed ? class_3417.field_15082 : class_3417.field_15131, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (moved || state.method_27852(newState.method_26204())) {
            return;
        }
        if (state.method_11654(STATE) == SEBStateEnum.PRESSED) {
            this.updateNeighbors(state, world, pos);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(STATE) == SEBStateEnum.PRESSED ? 15 : 0;
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        if (state.method_11654(STATE) == SEBStateEnum.PRESSED && EmergencyButton.method_10119((class_2680)state) == direction) {
            return 15;
        }
        return 0;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (state.method_11654(STATE) == SEBStateEnum.PRESSED) {
            world.method_8652(pos, (class_2680)state.method_11657(STATE, (Comparable)((Object)SEBStateEnum.OPEN)), 3);
            this.updateNeighbors(state, (class_1937)world, pos);
            this.playClickSound(null, (class_1936)world, pos, false);
            world.method_33596(null, class_5712.field_28175, pos);
        }
    }

    private void updateNeighbors(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8452(pos, (class_2248)this);
        world.method_8452(pos.method_10093(EmergencyButton.method_10119((class_2680)state).method_10153()), (class_2248)this);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        InfinityButtonsUtil.tooltip(tooltip, "safe_emergency_button");
    }
}

